/*
 * Decompiled with CFR 0.152.
 */
package compbio.engine;

import compbio.engine.FilePuller;
import compbio.engine.PulledFileCache;
import compbio.metadata.ChunkHolder;
import compbio.util.Util;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class ProgressGetter {
    private static final Logger log = Logger.getLogger(ProgressGetter.class);

    static final ChunkHolder pull(String string, long l, long l2, TimeUnit timeUnit) {
        if (Util.isEmpty(string)) {
            throw new NullPointerException("File must be supplied!");
        }
        FilePuller filePuller = PulledFileCache.get(string);
        if (filePuller == null) {
            filePuller = FilePuller.newFilePuller(string, 1024);
            if (l2 != 0L) {
                filePuller.setDelay(l2, timeUnit);
            }
            PulledFileCache.put(filePuller);
        }
        if (filePuller.isFileCreated()) {
            try {
                return filePuller.pull(l);
            }
            catch (IOException iOException) {
                log.error(iOException.getLocalizedMessage(), iOException.getCause());
            }
        }
        return null;
    }

    public static final ChunkHolder pull(String string, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Position must be greater then 0");
        }
        return ProgressGetter.pull(string, l, 0L, null);
    }

    static byte getProgress(String string, long l, TimeUnit timeUnit) {
        if (Util.isEmpty(string)) {
            throw new NullPointerException("File must be supplied!");
        }
        FilePuller filePuller = PulledFileCache.get(string);
        if (filePuller == null) {
            filePuller = FilePuller.newProgressPuller(string);
            if (l != 0L) {
                filePuller.setDelay(l, timeUnit);
            }
            PulledFileCache.put(filePuller);
        }
        if (filePuller.isFileCreated()) {
            try {
                byte by = filePuller.getProgress();
                return by;
            }
            catch (IOException iOException) {
                log.error(iOException.getLocalizedMessage(), iOException.getCause());
            }
        }
        return 0;
    }

    public static final byte getProgress(String string) {
        return ProgressGetter.getProgress(string, 0L, null);
    }
}

