/*
 * Decompiled with CFR 0.152.
 */
package compbio.engine;

import compbio.engine.FilePuller;
import compbio.engine.client.PathValidator;
import java.util.Queue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public final class PulledFileCache {
    private static final Logger log = Logger.getLogger(PulledFileCache.class);
    private static final Queue<FilePuller> CACHE = new DelayQueue<FilePuller>();

    public static FilePuller get(String string) {
        assert (PathValidator.isAbsolutePath(string));
        for (FilePuller filePuller : CACHE) {
            if (!filePuller.getFile().equals(string)) continue;
            log.debug("Retrieving element from cache: " + filePuller);
            return filePuller;
        }
        return null;
    }

    public static boolean put(FilePuller filePuller) {
        PulledFileCache.sweep();
        log.debug("Adding element to cache: " + filePuller);
        if (filePuller.getDelay(TimeUnit.NANOSECONDS) < 0L) {
            throw new IllegalArgumentException("Could not cache expired FilePullers! FilePuler: " + filePuller);
        }
        return CACHE.add(filePuller);
    }

    private static void sweep() {
        FilePuller filePuller = null;
        do {
            if ((filePuller = CACHE.poll()) == null) continue;
            filePuller.disconnect();
            log.debug("Removing element from cache: " + filePuller);
        } while (filePuller != null);
    }

    static int getSize() {
        return CACHE.size();
    }

    static void clear() {
        CACHE.clear();
    }

    static void print() {
        System.out.println(CACHE);
    }
}

