/*
 * Decompiled with CFR 0.152.
 */
package compbio.engine.client;

import compbio.engine.client.CommandBuilder;
import compbio.engine.client.ConfiguredExecutable;
import compbio.engine.client.EngineUtil;
import compbio.engine.client.EnvVariableProcessor;
import compbio.engine.client.Executable;
import compbio.engine.client.PathValidator;
import compbio.engine.client.RunConfiguration;
import compbio.engine.conf.PropertyHelperManager;
import compbio.engine.conf.RunnerConfigMarshaller;
import compbio.metadata.Limit;
import compbio.metadata.LimitsManager;
import compbio.metadata.PresetManager;
import compbio.metadata.ResultNotAvailableException;
import compbio.metadata.RunnerConfig;
import compbio.metadata.UnsupportedRuntimeException;
import compbio.util.FileUtil;
import compbio.util.PropertyHelper;
import compbio.util.SysPrefs;
import compbio.util.Util;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;

public class ConfExecutable<T>
implements ConfiguredExecutable<T> {
    private static final Logger log = Logger.getLogger(ConfExecutable.class);
    private static final PropertyHelper ph = PropertyHelperManager.getPropertyHelper();
    public static final String CLUSTER_TASK_ID_PREFIX = "@";
    private String workDirectory;
    private String taskDirectory;
    private Executable.ExecProvider provider;
    private Executable<T> exec;

    public ConfExecutable(Executable<T> executable, String string) {
        this.exec = executable;
        assert (!Util.isEmpty(string));
        this.taskDirectory = string;
    }

    ConfExecutable(RunConfiguration runConfiguration) {
        try {
            this.exec = (Executable)Class.forName(runConfiguration.runnerClassName).newInstance();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        this.exec.loadRunConfiguration(runConfiguration);
        this.setWorkDirectory(runConfiguration.workDirectory);
        this.taskDirectory = runConfiguration.taskId;
    }

    @Override
    public Executable.ExecProvider getExecProvider() {
        return this.provider;
    }

    public void setExecProvider(Executable.ExecProvider execProvider) {
        assert (execProvider != null && execProvider != Executable.ExecProvider.Any);
        this.provider = execProvider;
        if (execProvider == Executable.ExecProvider.Cluster) {
            this.taskDirectory = CLUSTER_TASK_ID_PREFIX + this.taskDirectory;
        }
    }

    @Override
    public String getCommand(Executable.ExecProvider execProvider) throws UnsupportedRuntimeException {
        String string = EngineUtil.getCommand(execProvider, this.exec.getClass());
        if (Util.isEmpty(string)) {
            throw new UnsupportedRuntimeException("Executable " + this.exec.getClass().getSimpleName() + " is not supported by the current runtime environment! Current runtime environment is " + (SysPrefs.isWindows ? "Windows " : "Linux/Unix/Mac"));
        }
        return string;
    }

    @Override
    public Executable.ExecProvider getSupportedRuntimes() {
        return EngineUtil.getSupportedRuntimes(this.exec.getClass());
    }

    @Override
    public Limit<T> getLimit(String string) {
        return this.exec.getLimit(string);
    }

    @Override
    public LimitsManager<T> getLimits() {
        return this.exec.getLimits();
    }

    @Override
    public String getTaskId() {
        return this.taskDirectory;
    }

    @Override
    public void setWorkDirectory(String string) {
        assert (!Util.isEmpty(string));
        this.workDirectory = string;
    }

    @Override
    public String getWorkDirectory() {
        return this.workDirectory;
    }

    @Override
    public Executable<T> addParameters(List<String> list) {
        this.exec.addParameters(list);
        return this.exec;
    }

    @Override
    public String getOutput() {
        return this.exec.getOutput();
    }

    @Override
    public String getError() {
        return this.exec.getError();
    }

    @Override
    public List<String> getCreatedFiles() {
        return this.getFullPath(this.exec.getCreatedFiles());
    }

    List<String> getFullPath(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            arrayList.add(EngineUtil.getFullPath(this.workDirectory, string));
        }
        return arrayList;
    }

    @Override
    public String getInput() {
        String string = this.exec.getInput();
        if (PathValidator.isAbsolutePath(string)) {
            return string;
        }
        return EngineUtil.getFullPath(this.workDirectory, string);
    }

    @Override
    public CommandBuilder<T> getParameters() {
        return this.exec.getParameters(this.provider);
    }

    @Override
    public CommandBuilder<T> getParameters(Executable.ExecProvider execProvider) {
        return this.getParameters();
    }

    @Override
    public Executable<T> getExecutable() {
        return this.exec;
    }

    @Override
    public <V> V getResults() throws ResultNotAvailableException {
        return this.exec.getResults(this.workDirectory);
    }

    @Override
    public <V> V getResults(String string) throws ResultNotAvailableException {
        return this.exec.getResults(string);
    }

    public static <V> RunnerConfig<V> getRunnerOptions(Class<? extends Executable<V>> clazz) throws IOException {
        String string = clazz.getSimpleName().toLowerCase() + ".parameters.file";
        return (RunnerConfig)ConfExecutable.getRunnerConfiguration(clazz, RunnerConfig.class, string);
    }

    public static <V> PresetManager<V> getRunnerPresets(Class<? extends Executable<V>> clazz) throws IOException {
        String string = clazz.getSimpleName().toLowerCase() + ".presets.file";
        PresetManager presetManager = (PresetManager)ConfExecutable.getRunnerConfiguration(clazz, PresetManager.class, string);
        return presetManager;
    }

    public static <V> LimitsManager<V> getRunnerLimits(Class<V> clazz) throws IOException {
        String string = clazz.getSimpleName().toLowerCase() + ".limits.file";
        LimitsManager limitsManager = (LimitsManager)ConfExecutable.getRunnerConfiguration(clazz, LimitsManager.class, string);
        return limitsManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <V> Object getRunnerConfiguration(Class<V> clazz, Class<?> clazz2, String string) throws IOException {
        Object var3_3 = null;
        FileInputStream fileInputStream = null;
        try {
            RunnerConfigMarshaller runnerConfigMarshaller = new RunnerConfigMarshaller(clazz2);
            String string2 = ph.getProperty(string);
            if (Util.isEmpty(string2)) {
                log.debug("Configuration " + string2 + " is not provided");
                Object var7_8 = null;
                return var7_8;
            }
            log.debug("Loading Configuration from " + string2 + " Config type:" + clazz2);
            File file = new File(PropertyHelperManager.getLocalPath() + string2);
            fileInputStream = new FileInputStream(file);
            var3_3 = runnerConfigMarshaller.read(fileInputStream, clazz2);
            fileInputStream.close();
            FileUtil.closeSilently(log, (Closeable)fileInputStream);
        }
        catch (JAXBException jAXBException) {
            log.error(jAXBException.getLocalizedMessage(), jAXBException.getCause());
        }
        finally {
            FileUtil.closeSilently(log, fileInputStream);
        }
        return var3_3;
    }

    @Override
    public Map<String, String> getEnvironment() {
        String string = ph.getProperty(this.exec.getClass().getSimpleName().toLowerCase() + ".bin.env");
        if (string == null) {
            return Collections.emptyMap();
        }
        return EnvVariableProcessor.getEnvVariables(string, this.getClass());
    }

    @Override
    public ConfiguredExecutable<?> loadRunConfiguration(RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            throw new NullPointerException("RunConfiguration is expected!");
        }
        return new ConfExecutable<T>(runConfiguration);
    }

    public static ConfiguredExecutable<?> newConfExecutable(RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            throw new NullPointerException("RunConfiguration is expected!");
        }
        return new ConfExecutable(runConfiguration);
    }

    @Override
    public boolean saveRunConfiguration() throws IOException {
        RunConfiguration runConfiguration = this.getRunConfiguration();
        return RunConfiguration.write(runConfiguration);
    }

    public RunConfiguration getRunConfiguration() {
        RunConfiguration runConfiguration = new RunConfiguration(this);
        return runConfiguration;
    }

    @Override
    public ConfiguredExecutable<?> loadRunConfiguration(InputStream inputStream) throws IOException {
        RunConfiguration runConfiguration = RunConfiguration.load(inputStream);
        log.info("Loaded saved RunConfiguration " + runConfiguration);
        return new ConfExecutable<T>(runConfiguration);
    }

    public String toString() {
        String string = "Work dir: " + this.workDirectory + "\n";
        string = string + "TaskId: " + this.taskDirectory + "\n";
        string = string + "Params: " + this.getParameters() + "\n";
        string = string + this.exec.toString();
        return string;
    }

    @Override
    public String getClusterJobSettings() {
        return this.exec.getClusterJobSettings();
    }
}

