/*
 * Decompiled with CFR 0.152.
 */
package compbio.engine.client;

import compbio.engine.client.CommandBuilder;
import compbio.engine.client.ConfExecutable;
import compbio.engine.conf.RunnerConfigMarshaller;
import compbio.util.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.log4j.Logger;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RunConfiguration {
    @XmlTransient
    private static Logger log = Logger.getLogger(RunConfiguration.class);
    @XmlTransient
    public static final String rconfigFile = "RunnerConfig.xml";
    @XmlElement(required=true)
    String taskId;
    @XmlElement(required=true)
    String workDirectory;
    @XmlElement(required=true)
    private CommandBuilder<?> parameters;
    @XmlElement(nillable=true)
    private String error;
    @XmlElement(nillable=true)
    private String output;
    @XmlElement(nillable=true)
    private String input;
    @XmlElement(required=true)
    String runnerClassName;

    public RunConfiguration() {
    }

    public RunConfiguration(ConfExecutable<?> confExecutable) {
        this.setParameters(confExecutable.getParameters());
        this.workDirectory = confExecutable.getWorkDirectory();
        this.taskId = confExecutable.getTaskId();
        this.runnerClassName = confExecutable.getExecutable().getClass().getCanonicalName();
        this.setOutput(confExecutable.getOutput());
        this.setInput(confExecutable.getInput());
        this.setError(confExecutable.getError());
    }

    public static boolean write(RunConfiguration runConfiguration) throws IOException {
        File file = new File(runConfiguration.workDirectory, rconfigFile);
        try {
            RunnerConfigMarshaller runnerConfigMarshaller = new RunnerConfigMarshaller(RunConfiguration.class);
            runnerConfigMarshaller.write(runConfiguration, new FileOutputStream(file));
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
            log.error("Failed to save RunConfiguration " + runConfiguration + " Error: " + jAXBException.getMessage(), jAXBException.getCause());
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error("Failed to save RunConfiguration " + runConfiguration + " Error: " + fileNotFoundException.getMessage(), fileNotFoundException.getCause());
        }
        return file.exists() && file.length() > 0L;
    }

    public static RunConfiguration load(InputStream inputStream) throws IOException {
        RunConfiguration runConfiguration = null;
        try {
            RunnerConfigMarshaller runnerConfigMarshaller = new RunnerConfigMarshaller(RunConfiguration.class);
            runConfiguration = runnerConfigMarshaller.read(inputStream, RunConfiguration.class);
        }
        catch (JAXBException jAXBException) {
            log.error("Failed to load RunConfiguration " + runConfiguration + " Error: " + jAXBException.getMessage(), jAXBException.getCause());
        }
        return runConfiguration;
    }

    public void setOutput(String string) {
        this.output = string;
    }

    public CommandBuilder<?> getParameters() {
        return this.parameters;
    }

    public void setParameters(CommandBuilder<?> commandBuilder) {
        this.parameters = commandBuilder;
    }

    public String getOutput() {
        return this.output;
    }

    public void setError(String string) {
        this.error = string;
    }

    public String getError() {
        return this.error;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String string) {
        this.input = string;
    }

    public String getRunnerClassName() {
        return this.runnerClassName;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof RunConfiguration)) {
            return false;
        }
        RunConfiguration runConfiguration = (RunConfiguration)object;
        if (!this.strEquals(this.error, runConfiguration.error)) {
            return false;
        }
        if (!this.strEquals(this.input, runConfiguration.input)) {
            return false;
        }
        if (!this.strEquals(this.output, runConfiguration.output)) {
            return false;
        }
        if (!this.strEquals(this.runnerClassName, runConfiguration.runnerClassName)) {
            return false;
        }
        if (!this.strEquals(this.taskId, runConfiguration.taskId)) {
            return false;
        }
        if (!this.strEquals(this.workDirectory, runConfiguration.workDirectory)) {
            return false;
        }
        return this.parameters.equals(runConfiguration.parameters);
    }

    private boolean strEquals(String string, String string2) {
        return Util.isEmpty(string) || Util.isEmpty(string2) || string.equals(string2);
    }

    public int hashCode() {
        int n = this.taskId.hashCode() * this.runnerClassName.hashCode();
        return n *= this.parameters.hashCode();
    }

    public String toString() {
        String string = "Class : " + this.runnerClassName + "\n";
        string = string + "TaskId: " + this.taskId + "\n";
        string = string + "Input: " + this.input + "\n";
        string = string + "Output: " + this.output + "\n";
        string = string + "Error: " + this.error + "\n";
        string = string + "Workdir: " + this.workDirectory + "\n";
        string = string + "Param: " + this.parameters + "\n";
        return string;
    }
}

