/*
 * Decompiled with CFR 0.152.
 */
package compbio.engine.cluster.drmaa;

import compbio.engine.ClusterJobId;
import compbio.engine.Configurator;
import compbio.engine.Job;
import compbio.engine.client.ConfiguredExecutable;
import compbio.engine.client.EngineUtil;
import compbio.engine.client.PathValidator;
import compbio.engine.cluster.drmaa.StatisticManager;
import compbio.engine.conf.PropertyHelperManager;
import compbio.metadata.JobStatus;
import compbio.metadata.ResultNotAvailableException;
import compbio.util.FileUtil;
import compbio.util.PropertyHelper;
import compbio.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;
import org.ggf.drmaa.DrmaaException;
import org.ggf.drmaa.InvalidJobException;
import org.ggf.drmaa.JobInfo;
import org.ggf.drmaa.Session;
import org.ggf.drmaa.SessionFactory;

public final class ClusterSession {
    private static final Logger log = Logger.getLogger(ClusterSession.class);
    private static final PropertyHelper ph = PropertyHelperManager.getPropertyHelper();
    public static final String JOBID = "JOBID";
    static final List<Job> jobs = new CopyOnWriteArrayList<Job>();
    private static boolean open = true;
    private static final ClusterSession INSTANCE = new ClusterSession();
    private final Session session;
    private final String sContact;

    private ClusterSession() {
        log.debug("Initializing session " + Util.datef.format(Calendar.getInstance().getTime()));
        SessionFactory sessionFactory = SessionFactory.getFactory();
        this.session = sessionFactory.getSession();
        this.sContact = this.session.getContact();
        try {
            this.session.init(null);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    ClusterSession.this.close();
                }
            });
        }
        catch (DrmaaException drmaaException) {
            log.error(drmaaException.getMessage());
        }
    }

    static synchronized ClusterSession getInstance() {
        return INSTANCE;
    }

    public Session getSession() {
        return ClusterSession.INSTANCE.session;
    }

    public void close() {
        try {
            if (open) {
                this.session.exit();
                open = false;
                log.debug("Closing the session at: " + Util.datef.format(Calendar.getInstance().getTime()));
            }
        }
        catch (DrmaaException drmaaException) {
            drmaaException.printStackTrace();
        }
    }

    void addJob(String string, ConfiguredExecutable<?> configuredExecutable) {
        String string2 = configuredExecutable.getTaskId();
        assert (!PathValidator.isValidDirectory(string2)) : "Directory provided is not valid! Directory: " + string2;
        assert (!Util.isEmpty(string));
        EngineUtil.writeStatFile(configuredExecutable.getWorkDirectory(), JobStatus.SUBMITTED.toString());
        EngineUtil.writeFile(configuredExecutable.getWorkDirectory(), JOBID, string, false);
        log.debug("Adding taskId: " + string2 + " to cluster job list");
        assert (EngineUtil.isValidJobId(string2));
        jobs.add(new Job(string2, string, configuredExecutable));
    }

    public void removeJob(String string) {
        assert (!Util.isEmpty(string));
        assert (EngineUtil.isValidJobId(string));
        ClusterSession.removeJobFromListbyTaskId(string);
    }

    public JobInfo waitForJob(String string) throws DrmaaException, IOException {
        return this.waitForJob(string, -1L);
    }

    public static ClusterJobId getClusterJobId(String string) throws IOException {
        Job job = Job.getByTaskId(string, jobs);
        if (job != null) {
            return job.getJobId();
        }
        String string2 = Configurator.getWorkDirectory(string);
        assert (!Util.isEmpty(string2));
        File file = new File(string2, JOBID);
        log.debug("Looking up cluster jobid by the task id " + string + " File path is " + file.getAbsolutePath());
        assert (file.exists());
        return new ClusterJobId(FileUtil.readFileToString(file));
    }

    public JobInfo waitForJob(String string, long l) throws DrmaaException, IOException {
        ClusterJobId clusterJobId = ClusterSession.getClusterJobId(string);
        JobInfo jobInfo = this.session.wait(clusterJobId.getJobId(), l);
        EngineUtil.writeStatFile(Configurator.getWorkDirectory(string), JobStatus.FINISHED.toString());
        return jobInfo;
    }

    private static void removeJobFromListbyTaskId(String string) {
        assert (!Util.isEmpty(string));
        Job job = Job.getByTaskId(string, jobs);
        if (job != null) {
            log.debug("Removing taskId" + string + " from cluster job list");
            jobs.remove(job);
        }
    }

    public ConfiguredExecutable<?> getResults(String string) throws DrmaaException, ResultNotAvailableException {
        ConfiguredExecutable<?> configuredExecutable;
        EngineUtil.isValidJobId(string);
        try {
            configuredExecutable = this.waitForJob(string);
        }
        catch (InvalidJobException invalidJobException) {
            log.warn("Could not find the cluster job with id " + string + " perhaps it has completed", invalidJobException.getCause());
        }
        catch (IOException iOException) {
            log.error("Could not read JOBID file for the job " + string + " Message " + iOException.getLocalizedMessage(), iOException.getCause());
        }
        configuredExecutable = null;
        Job job = Job.getByTaskId(string, jobs);
        if (job != null) {
            configuredExecutable = job.getConfExecutable();
            ClusterSession.removeJobFromListbyTaskId(string);
        } else {
            configuredExecutable = EngineUtil.loadExecutable(string);
        }
        if (configuredExecutable != null) {
            EngineUtil.writeMarker(configuredExecutable.getWorkDirectory(), JobStatus.COLLECTED);
        }
        return configuredExecutable;
    }

    public static StatisticManager getStatistics(JobInfo jobInfo) throws DrmaaException {
        return new StatisticManager(jobInfo);
    }

    static void logStatistics(JobInfo jobInfo) throws DrmaaException {
        log.info(ClusterSession.getStatistics(jobInfo).getAllStats());
    }

    public int getJobStatus(ClusterJobId clusterJobId) throws DrmaaException, InvalidJobException {
        return this.session.getJobProgramStatus(clusterJobId.getJobId());
    }

    @Deprecated
    public static String getJobStatus(int n) throws DrmaaException {
        String string = null;
        switch (n) {
            case 0: {
                string = "Job status cannot be determined\n";
                break;
            }
            case 16: {
                string = "Job is queued and active\n";
                break;
            }
            case 17: {
                string = "Job is queued and in system hold\n";
                break;
            }
            case 18: {
                string = "Job is queued and in user hold\n";
                break;
            }
            case 19: {
                string = "Job is queued and in user and system hold\n";
                break;
            }
            case 32: {
                string = "Job is running\n";
                break;
            }
            case 33: {
                string = "Job is system suspended\n";
                break;
            }
            case 34: {
                string = "Job is user suspended\n";
                break;
            }
            case 35: {
                string = "Job is user and system suspended\n";
                break;
            }
            case 48: {
                string = "Job finished normally\n";
                break;
            }
            case 64: {
                string = "Job finished, but failed\n";
            }
        }
        return string;
    }
}

