/*
 * Decompiled with CFR 0.152.
 */
package compbio.engine.local;

import compbio.engine.client.ConfiguredExecutable;
import compbio.engine.client.EngineUtil;
import compbio.engine.client.Executable;
import compbio.engine.client.PathValidator;
import compbio.engine.client.PipedExecutable;
import compbio.metadata.JobSubmissionException;
import compbio.util.SysPrefs;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public final class ExecutableWrapper
implements Callable<ConfiguredExecutable<?>> {
    public static final String PROC_IN_FILE = "procInput.txt";
    public static final String PROC_OUT_FILE = "procOutput.txt";
    public static final String PROC_ERR_FILE = "procError.txt";
    private static ExecutorService es;
    private final ConfiguredExecutable<?> confExec;
    private final ProcessBuilder pbuilder;
    private static final Logger log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutableWrapper(ConfiguredExecutable<?> configuredExecutable, String string) throws JobSubmissionException {
        this.confExec = configuredExecutable;
        String string2 = null;
        try {
            string2 = configuredExecutable.getCommand(Executable.ExecProvider.Local);
            PathValidator.validateExecutable(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error(illegalArgumentException.getMessage(), illegalArgumentException.getCause());
            throw new JobSubmissionException(illegalArgumentException);
        }
        List<String> list = configuredExecutable.getParameters().getCommands();
        list.add(0, string2);
        this.pbuilder = new ProcessBuilder(list);
        if (configuredExecutable.getEnvironment() != null) {
            log.debug("Setting command environment variables: " + this.pbuilder.environment());
            EngineUtil.mergeEnvVariables(this.pbuilder.environment(), configuredExecutable.getEnvironment());
            log.debug("Process environment:" + this.pbuilder.environment());
        }
        log.debug("Setting command: " + this.pbuilder.command());
        PathValidator.validateDirectory(string);
        this.pbuilder.directory(new File(string));
        log.debug("Current working directory is " + SysPrefs.getCurrentDirectory());
        log.debug("Setting working directory: " + string);
        Logger logger = log;
        synchronized (logger) {
            if (es == null) {
                es = Executors.newCachedThreadPool();
                log.debug("Initializing executor for local processes output dump");
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        ExecutableWrapper.shutdownService();
                    }
                });
            }
        }
    }

    public static final void shutdownService() {
        if (es != null) {
            es.shutdownNow();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public ConfiguredExecutable<?> call() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getOutput() {
        if (this.confExec.getOutput() != null && this.confExec.getExecutable() instanceof PipedExecutable) {
            return this.confExec.getOutput();
        }
        return PROC_OUT_FILE;
    }

    private String getError() {
        if (this.confExec.getError() != null && this.confExec.getExecutable() instanceof PipedExecutable) {
            return this.confExec.getError();
        }
        return PROC_ERR_FILE;
    }

    static {
        log = Logger.getLogger(ExecutableWrapper.class);
    }
}

