/*
 * Decompiled with CFR 0.152.
 */
package compbio.engine.local;

import compbio.engine.SyncExecutor;
import compbio.engine.client.ConfiguredExecutable;
import compbio.engine.local.ExecutableWrapper;
import compbio.engine.local.LocalEngineUtil;
import compbio.engine.local.LocalExecutorService;
import compbio.metadata.JobExecutionException;
import compbio.metadata.JobStatus;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.ResultNotAvailableException;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public final class LocalRunner
implements SyncExecutor {
    private static final Logger log = Logger.getLogger(LocalRunner.class);
    private final ExecutorService executor;
    private final ConfiguredExecutable<?> executable;
    private Future<ConfiguredExecutable<?>> future;
    private final String workDirectory;

    public LocalRunner(ConfiguredExecutable<?> configuredExecutable) {
        if (configuredExecutable == null) {
            throw new IllegalArgumentException("Executable value is NULL. Executable must be provided!");
        }
        this.executor = LocalExecutorService.getExecutor();
        this.executable = configuredExecutable;
        this.workDirectory = configuredExecutable.getWorkDirectory();
        try {
            configuredExecutable.saveRunConfiguration();
        }
        catch (IOException iOException) {
            log.error("Could not save run configuration! " + iOException.getMessage(), iOException.getCause());
        }
    }

    @Override
    public String getWorkDirectory() {
        return this.workDirectory;
    }

    @Override
    public boolean cancelJob() {
        return LocalEngineUtil.cancelJob(this.future, this.getWorkDirectory());
    }

    Future<ConfiguredExecutable<?>> getFuture() {
        return this.future;
    }

    @Override
    public JobStatus getJobStatus() {
        if (this.future == null) {
            return LocalEngineUtil.getRecordedJobStatus(this.executable.getTaskId());
        }
        return LocalEngineUtil.getJobStatus(this.future);
    }

    @Override
    public void executeJob() throws JobSubmissionException {
        ExecutableWrapper executableWrapper = new ExecutableWrapper(this.executable, this.workDirectory);
        this.future = this.executor.submit(executableWrapper);
    }

    @Override
    public ConfiguredExecutable<?> waitForResult() throws JobExecutionException {
        try {
            return LocalEngineUtil.getResults(this.future, this.executable.getTaskId());
        }
        catch (ResultNotAvailableException resultNotAvailableException) {
            throw new JobExecutionException(resultNotAvailableException);
        }
    }

    @Override
    public boolean cleanup() {
        return LocalEngineUtil.cleanup(this.executable);
    }
}

