/*
 * Decompiled with CFR 0.152.
 */
package compbio.engine.local;

import compbio.util.SysPrefs;
import compbio.util.annotation.ThreadSafe;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.log4j.Logger;

@ThreadSafe
public class StreamGobbler
implements Runnable {
    private static final Logger log = Logger.getLogger(StreamGobbler.class);
    private final InputStream is;
    private final OutputStream os;
    private final OutputType type;

    StreamGobbler(InputStream inputStream, OutputStream outputStream, OutputType outputType) {
        this.is = inputStream;
        this.os = outputStream;
        this.type = outputType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.is));
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.os));
        String string = null;
        try {
            while ((string = bufferedReader.readLine()) != null && !Thread.interrupted()) {
                log.trace((Object)((Object)this.type) + ">" + string);
                bufferedWriter.write(string + SysPrefs.newlinechar);
            }
            bufferedReader.close();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            log.error(iOException.getMessage(), iOException.getCause());
        }
        finally {
            StreamGobbler.closeSilently(bufferedReader);
            StreamGobbler.closeSilently(bufferedWriter);
        }
    }

    private static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                log.error(iOException.getLocalizedMessage(), iOException.getCause());
            }
        }
    }

    static enum OutputType {
        OUTPUT,
        ERROR;

    }
}

