/*
 * Decompiled with CFR 0.152.
 */
package compbio.runner;

import compbio.data.sequence.Alignment;
import compbio.data.sequence.ClustalAlignmentUtil;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.RNAStructReader;
import compbio.data.sequence.RNAStructScoreManager;
import compbio.data.sequence.Score;
import compbio.data.sequence.SequenceUtil;
import compbio.data.sequence.UnknownFileFormatException;
import compbio.engine.client.ConfExecutable;
import compbio.engine.client.ConfiguredExecutable;
import compbio.engine.client.EngineUtil;
import compbio.engine.client.Executable;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.PresetManager;
import compbio.metadata.RunnerConfig;
import compbio.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class RunnerUtil {
    public static Logger log = Logger.getLogger(RunnerUtil.class);

    public static synchronized <T> RunnerConfig<T> getSupportedOptions(Class<? extends Executable<T>> clazz) {
        try {
            return ConfExecutable.getRunnerOptions(clazz);
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error("Could not load " + clazz + " parameters !" + fileNotFoundException.getMessage(), fileNotFoundException.getCause());
        }
        catch (IOException iOException) {
            log.error("IO exception while reading " + clazz + " parameters !" + iOException.getMessage(), iOException.getCause());
        }
        return null;
    }

    public static <T> PresetManager<T> getPresets(Class<? extends Executable<T>> clazz) {
        try {
            return ConfExecutable.getRunnerPresets(clazz);
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.warn("No presets are found for " + clazz + "! " + fileNotFoundException.getLocalizedMessage(), fileNotFoundException.getCause());
        }
        catch (IOException iOException) {
            log.warn("IO exception while reading presets for " + clazz + "! " + iOException.getLocalizedMessage(), iOException.getCause());
        }
        return null;
    }

    public static final Alignment readClustalFile(String string, String string2) throws UnknownFileFormatException, IOException, FileNotFoundException, NullPointerException {
        assert (!Util.isEmpty(string));
        assert (!Util.isEmpty(string2));
        File file = new File(EngineUtil.getFullPath(string, string2));
        log.trace("CLUSTAL OUTPUT FILE PATH: " + file.getAbsolutePath());
        if (!file.exists() || file.length() <= 0L) {
            throw new FileNotFoundException("Result for the jobId " + string + " with file name " + string2 + " is not found!");
        }
        return ClustalAlignmentUtil.readClustalFile(file);
    }

    public static final Map<String, Score> readJronnFile(String string, String string2) throws UnknownFileFormatException, IOException, FileNotFoundException, NullPointerException {
        assert (!Util.isEmpty(string));
        assert (!Util.isEmpty(string2));
        File file = new File(EngineUtil.getFullPath(string, string2));
        log.trace("Jronn OUTPUT FILE PATH: " + file.getAbsolutePath());
        if (!file.exists() || file.length() <= 0L) {
            throw new FileNotFoundException("Result for the jobId " + string + " with file name " + string2 + " is not found!");
        }
        return SequenceUtil.readJRonn(file);
    }

    public static void writeInput(List<FastaSequence> list, ConfiguredExecutable<?> configuredExecutable) throws JobSubmissionException {
        try {
            File file = new File(configuredExecutable.getInput());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            log.debug("File path: " + file.getAbsolutePath());
            SequenceUtil.writeFasta(fileOutputStream, list);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            log.error("IOException while writing input file into the disk: " + iOException.getLocalizedMessage(), iOException);
            throw new JobSubmissionException("We are sorry by JABAWS server seems to have a problem! " + iOException.getLocalizedMessage(), iOException);
        }
    }

    public static void writeClustalInput(List<FastaSequence> list, ConfiguredExecutable<?> configuredExecutable, char c) throws JobSubmissionException {
        try {
            File file = new File(configuredExecutable.getInput());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            log.debug("File path: " + file.getAbsolutePath());
            SequenceUtil.writeClustal(fileOutputStream, list, c);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            log.error("IOException while writing input file into the disk: " + iOException.getLocalizedMessage(), iOException);
            throw new JobSubmissionException("We are sorry but JABAWS server seems to have a problem! " + iOException.getLocalizedMessage(), iOException);
        }
    }

    public static RNAStructScoreManager readRNAStruct(String string, String string2) throws IOException, FileNotFoundException {
        assert (!Util.isEmpty(string));
        assert (!Util.isEmpty(string2));
        File file = new File(EngineUtil.getFullPath(string, string2));
        File file2 = new File(EngineUtil.getFullPath(string, "alifold.out"));
        if (!file.exists() || file.length() <= 0L) {
            throw new FileNotFoundException("Result for the jobId " + string + "with file name " + string2 + " is not found!");
        }
        if (!file2.exists()) {
            log.warn("The file alifold.out is not found for the jobId " + string + "Is the -p or --MEA option not specified?");
            return RNAStructReader.readRNAStructStream(new FileInputStream(file));
        }
        return RNAStructReader.readRNAStructStream(new FileInputStream(file), new FileInputStream(file2));
    }
}

