/*
 * Decompiled with CFR 0.152.
 */
package compbio.runner;

import compbio.data.sequence.Alignment;
import compbio.data.sequence.ClustalAlignmentUtil;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.Score;
import compbio.data.sequence.SequenceUtil;
import compbio.data.sequence.UnknownFileFormatException;
import compbio.engine.client.ConfExecutable;
import compbio.engine.client.ConfiguredExecutable;
import compbio.engine.client.Executable;
import compbio.engine.conf.PropertyHelperManager;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.PresetManager;
import compbio.metadata.RunnerConfig;
import compbio.util.PropertyHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class Util {
    public static Logger log = Logger.getLogger(Util.class);
    private static final PropertyHelper ph = PropertyHelperManager.getPropertyHelper();
    public static final String SPACE = " ";

    public static synchronized <T> RunnerConfig<T> getSupportedOptions(Class<? extends Executable<T>> clazz) {
        try {
            return ConfExecutable.getRunnerOptions(clazz);
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error("Could not load " + clazz + " Parameters !" + fileNotFoundException.getMessage(), fileNotFoundException.getCause());
        }
        catch (IOException iOException) {
            log.error("IO exception while reading " + clazz + " Parameters !" + iOException.getMessage(), iOException.getCause());
        }
        return null;
    }

    public static <T> PresetManager<T> getPresets(Class<? extends Executable<T>> clazz) {
        try {
            return ConfExecutable.getRunnerPresets(clazz);
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.warn("No presets are found for " + clazz + " executable! " + fileNotFoundException.getLocalizedMessage(), fileNotFoundException.getCause());
        }
        catch (IOException iOException) {
            log.warn("IO exception while reading presents! for " + clazz + " executable! " + iOException.getLocalizedMessage(), iOException.getCause());
        }
        return null;
    }

    public static final Alignment readClustalFile(String string, String string2) throws UnknownFileFormatException, IOException, FileNotFoundException, NullPointerException {
        assert (!compbio.util.Util.isEmpty(string));
        assert (!compbio.util.Util.isEmpty(string2));
        File file = new File(compbio.engine.client.Util.getFullPath(string, string2));
        log.trace("CLUSTAL OUTPUT FILE PATH: " + file.getAbsolutePath());
        if (!file.exists() || file.length() <= 0L) {
            throw new FileNotFoundException("Result for the jobId " + string + " with file name " + string2 + " is not found!");
        }
        return ClustalAlignmentUtil.readClustalFile(file);
    }

    public static final Map<String, Score> readJronnFile(String string, String string2) throws UnknownFileFormatException, IOException, FileNotFoundException, NullPointerException {
        assert (!compbio.util.Util.isEmpty(string));
        assert (!compbio.util.Util.isEmpty(string2));
        File file = new File(compbio.engine.client.Util.getFullPath(string, string2));
        log.trace("Jronn OUTPUT FILE PATH: " + file.getAbsolutePath());
        if (!file.exists() || file.length() <= 0L) {
            throw new FileNotFoundException("Result for the jobId " + string + " with file name " + string2 + " is not found!");
        }
        return SequenceUtil.readJRonn(file);
    }

    public static void writeInput(List<FastaSequence> list, ConfiguredExecutable<?> configuredExecutable) throws JobSubmissionException {
        try {
            File file = new File(configuredExecutable.getInput());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            log.debug("File path: " + file.getAbsolutePath());
            SequenceUtil.writeFasta(fileOutputStream, list);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            log.error("IOException while writing input file into the disk: " + iOException.getLocalizedMessage(), iOException);
            throw new JobSubmissionException("We are sorry by JABAWS server seems to have a problem! " + iOException.getLocalizedMessage(), iOException);
        }
    }
}

