/*
 * Decompiled with CFR 0.152.
 */
package compbio.runner.conservation;

import compbio.data.sequence.ScoreManager;
import compbio.data.sequence.SequenceUtil;
import compbio.engine.client.CommandBuilder;
import compbio.engine.client.EngineUtil;
import compbio.engine.client.Executable;
import compbio.engine.client.SkeletalExecutable;
import compbio.metadata.ResultNotAvailableException;
import compbio.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class AACon
extends SkeletalExecutable<AACon> {
    private static Logger log = Logger.getLogger(AACon.class);
    private int ncoreNumber = 0;
    private final String ncorePrm = "-t=";
    public static final String KEY_VALUE_SEPARATOR = "=";
    public static final String STAT_FILE = "stat.txt";

    public AACon() {
        this.addParameters(Arrays.asList("-jar", AACon.getLibPath(), "-d=stat.txt", "-f=RESULT_NO_ALIGNMENT"));
    }

    @Override
    public ScoreManager getResults(String string) throws ResultNotAvailableException {
        ScoreManager scoreManager = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(string, this.getOutput()));
            scoreManager = ScoreManager.newInstanceSingleSequence(SequenceUtil.readAAConResults(fileInputStream));
            ((InputStream)fileInputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error(fileNotFoundException.getMessage(), fileNotFoundException.getCause());
            throw new ResultNotAvailableException(fileNotFoundException);
        }
        catch (IOException iOException) {
            log.error(iOException.getMessage(), iOException.getCause());
            throw new ResultNotAvailableException(iOException);
        }
        catch (NullPointerException nullPointerException) {
            log.error(nullPointerException.getMessage(), nullPointerException.getCause());
            throw new ResultNotAvailableException(nullPointerException);
        }
        return scoreManager;
    }

    private static String getLibPath() {
        String string = ph.getProperty("aacon.jar.file");
        if (Util.isEmpty(string)) {
            throw new NullPointerException("Please define aacon.jar.file property in Executable.properties file and initialize it with the location of aaconservation jar file");
        }
        if (new File(string).isAbsolute()) {
            return string;
        }
        return EngineUtil.convertToAbsolute(string);
    }

    @Override
    public List<String> getCreatedFiles() {
        return Arrays.asList(this.getOutput(), this.getError());
    }

    public AACon setInput(String string) {
        super.setInput(string);
        this.cbuilder.setParam("-i=" + string);
        return this;
    }

    public AACon setOutput(String string) {
        super.setOutput(string);
        this.cbuilder.setParam("-o=" + string);
        return this;
    }

    @Override
    public Class<AACon> getType() {
        return this.getClass();
    }

    public static String getStatFile() {
        return STAT_FILE;
    }

    public void setNCore(int n) {
        if (n < 1 || n > 100) {
            throw new IndexOutOfBoundsException("Number of cores must be within 1 and 100 ");
        }
        this.ncoreNumber = n;
        this.cbuilder.setParam("-t=" + Integer.toString(this.getNCore()));
    }

    int getNCore() {
        return this.ncoreNumber;
    }

    @Override
    public CommandBuilder<AACon> getParameters(Executable.ExecProvider execProvider) {
        if (execProvider == Executable.ExecProvider.Cluster) {
            int n = SkeletalExecutable.getClusterCpuNum(this.getType());
            n = n == 0 ? 1 : n;
            this.setNCore(n);
        } else if (this.ncoreNumber == 0) {
            this.setNCore(1);
        }
        return super.getParameters(execProvider);
    }
}

