/*
 * Decompiled with CFR 0.152.
 */
package compbio.stat.collector;

import compbio.engine.client.PathValidator;
import compbio.stat.collector.InputFilter;
import compbio.stat.collector.JobDirectory;
import compbio.stat.collector.JobStat;
import compbio.stat.collector.StatDB;
import compbio.stat.collector.StatProcessor;
import compbio.util.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class ExecutionStatCollector
implements Runnable {
    static final int UNDEFINED = -1;
    static SimpleDateFormat DF = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
    private static final Logger log = Logger.getLogger(ExecutionStatCollector.class);
    private final File workingDirectory;
    private final List<JobStat> stats;
    private final int timeOutInHours;
    static FileFilter directories = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() && !file.getName().startsWith(".");
        }
    };

    public ExecutionStatCollector(String string, int n) {
        log.info("Starting stat collector for directory: " + string);
        log.info("Maximum allowed runtime(h): " + n);
        if (!PathValidator.isValidDirectory(string)) {
            throw new IllegalArgumentException("workingDirectory '" + string + "' does not exist!");
        }
        this.workingDirectory = new File(string);
        this.stats = new ArrayList<JobStat>();
        if (n <= 0) {
            throw new IllegalArgumentException("Timeout value must be greater than 0! Given value: " + n);
        }
        this.timeOutInHours = n;
    }

    boolean hasCompleted(JobDirectory jobDirectory) {
        JobStat jobStat = jobDirectory.getJobStat();
        return jobStat.hasResult() || jobStat.getIsCancelled() || jobStat.getIsFinished() || this.hasTimedOut(jobDirectory);
    }

    boolean hasTimedOut(JobDirectory jobDirectory) {
        return (System.currentTimeMillis() - jobDirectory.jobdir.lastModified()) / 3600000L > (long)this.timeOutInHours;
    }

    StatProcessor getStats() {
        if (this.stats.isEmpty()) {
            log.info("Please make sure collectStatistics method was called prior to calling getStats()!");
        }
        return new StatProcessor(this.stats);
    }

    void writeStatToDB() throws SQLException {
        HashSet<JobStat> hashSet = new HashSet<JobStat>(this.stats);
        StatDB statDB = new StatDB();
        log.debug("Removing records that has already been recorded");
        statDB.removeRecordedJobs(hashSet);
        log.debug("New records left: " + hashSet.size());
        statDB.insertData(hashSet);
    }

    public static void main(String[] stringArray) throws IOException, SQLException {
        File[] fileArray = FileUtil.getFiles("Y:\\fc\\www-jws2\\jaba\\jobsout", directories);
        ArrayList<JobStat> arrayList = new ArrayList<JobStat>();
        for (File file : fileArray) {
            JobDirectory jobDirectory = new JobDirectory(file);
            arrayList.add(jobDirectory.getJobStat());
        }
        StatProcessor statProcessor = new StatProcessor(arrayList);
        System.out.println(statProcessor.reportStat());
        System.out.println();
        System.out.println("!!!!!!!!!!!!!!!!!!");
        System.out.println();
        HashSet<JobStat> hashSet = new HashSet<JobStat>(statProcessor.stats);
        StatDB statDB = new StatDB();
        statDB.removeRecordedJobs(hashSet);
        statDB.insertData(hashSet);
    }

    void collectStatistics() {
        File[] fileArray;
        this.stats.clear();
        for (File file : fileArray = this.workingDirectory.listFiles(directories)) {
            log.debug("check directory: " + file.getName() + "...");
            if (InputFilter.accept(new File(file.getPath() + File.separator + "input.txt"))) {
                JobDirectory jobDirectory = new JobDirectory(file);
                JobStat jobStat = jobDirectory.getJobStat();
                if (this.hasCompleted(jobDirectory)) {
                    this.stats.add(jobStat);
                    continue;
                }
                log.debug("Skipping the job: " + jobStat + " as it has not completed yet");
                continue;
            }
            log.trace("training input: " + file.getName() + File.separator + "input.txt");
        }
    }

    @Override
    public void run() {
        log.info("Started updating statistics at " + new Date());
        log.info("For directory: " + this.workingDirectory.getAbsolutePath());
        this.collectStatistics();
        StatProcessor statProcessor = this.getStats();
        log.info("Found " + statProcessor.getJobNumber() + " jobs!");
        try {
            this.writeStatToDB();
        }
        catch (SQLException sQLException) {
            log.error("Fails to update jobs statistics database!");
            log.error(sQLException.getLocalizedMessage(), sQLException);
        }
        log.info("Finished updating statistics at " + new Date());
    }
}

