/*
 * Decompiled with CFR 0.152.
 */
package compbio.stat.collector;

import compbio.engine.client.Executable;
import compbio.metadata.JobStatus;
import compbio.stat.collector.JobStat;
import compbio.util.FileUtil;
import compbio.ws.client.Services;
import compbio.ws.client.ServicesUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class JobDirectory {
    static final int UNDEFINED = -1;
    private static final Logger log = Logger.getLogger(JobDirectory.class);
    File jobdir;
    Map<String, File> files = new HashMap<String, File>();

    JobDirectory(File file) {
        this.jobdir = file;
        for (File file2 : this.jobdir.listFiles()) {
            this.files.put(file2.getName(), file2);
        }
    }

    boolean hasStatus(JobStatus jobStatus) {
        return this.files.containsKey(jobStatus.toString());
    }

    boolean isCollected() {
        return this.hasStatus(JobStatus.COLLECTED);
    }

    boolean isCancelled() {
        return this.hasStatus(JobStatus.CANCELLED);
    }

    long getStartTime() {
        long l = -1L;
        File file = this.files.get(JobStatus.STARTED.toString());
        if (file == null) {
            file = this.files.get(JobStatus.SUBMITTED.toString());
        }
        try {
            if (file != null) {
                String string = FileUtil.readFileToString(file);
                l = Long.parseLong(string.trim());
            }
        }
        catch (IOException iOException) {
            log.warn("IOException while reading STARTED status file! Ignoring...", iOException);
            l = file.lastModified();
        }
        catch (NumberFormatException numberFormatException) {
            log.warn("NumberFormatException while reading STARTED status file! Ignoring...", numberFormatException);
            l = file.lastModified();
        }
        return l;
    }

    String getClusterJobID() {
        String string = "";
        File file = this.files.get("JOBID");
        try {
            if (file != null) {
                string = FileUtil.readFileToString(file);
            }
        }
        catch (IOException iOException) {
            log.error("IO Exception while reading the content of JOBID file for job " + file, iOException);
        }
        return string.trim();
    }

    long getFinishedTime() {
        long l = -1L;
        File file = this.files.get(JobStatus.FINISHED.toString());
        if (file != null) {
            try {
                if (file != null) {
                    String string = FileUtil.readFileToString(file);
                    l = Long.parseLong(string.trim());
                }
            }
            catch (IOException iOException) {
                log.warn("IOException while reading FINISHED status file! Ignoring...", iOException);
                l = file.lastModified();
            }
            catch (NumberFormatException numberFormatException) {
                log.warn("NumberFormatException while reading FINISHED status file! Ignoring...", numberFormatException);
                l = file.lastModified();
            }
        }
        return l;
    }

    private Services getService() {
        return ServicesUtil.getServiceByJobDirectory(this.jobdir);
    }

    long getResultSize() {
        Class<Executable<?>> clazz = ServicesUtil.getRunnerByJobDirectory(this.jobdir);
        File file = null;
        if (clazz.getSimpleName().equalsIgnoreCase("IUPred")) {
            file = this.files.get("out.glob");
            if (file == null) {
                file = this.files.get("out.short");
            }
            if (file == null) {
                file = this.files.get("out.long");
            }
        } else {
            file = this.files.get("result.txt");
        }
        if (file != null) {
            return file.length();
        }
        return -1L;
    }

    long getInputSize() {
        Class<? extends Executable<?>> clazz = ServicesUtil.getRunnerByJobDirectory(this.jobdir);
        File file = this.files.get("input.txt");
        if (file != null) {
            return file.length();
        }
        return -1L;
    }

    JobStat getJobStat() {
        return JobStat.newInstance(this.getService(), this.getClusterJobID(), this.jobdir.getName(), this.getStartTime(), this.getFinishedTime(), this.getInputSize(), this.getResultSize(), this.isCancelled(), this.isCollected());
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.jobdir == null ? 0 : this.jobdir.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JobDirectory jobDirectory = (JobDirectory)object;
        return !(this.jobdir == null ? jobDirectory.jobdir != null : !this.jobdir.equals(jobDirectory.jobdir));
    }
}

