/*
 * Decompiled with CFR 0.152.
 */
package compbio.stat.collector;

import compbio.stat.collector.ExecutionStatCollector;
import compbio.util.Util;
import compbio.ws.client.Services;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;

public class JobStat {
    static final Comparator<JobStat> RUNTIME = new Comparator<JobStat>(){

        @Override
        public int compare(JobStat jobStat, JobStat jobStat2) {
            return new Integer(jobStat2.getRuntime()).compareTo(jobStat.getRuntime());
        }
    };
    static final Comparator<JobStat> STARTTIME = new Comparator<JobStat>(){

        @Override
        public int compare(JobStat jobStat, JobStat jobStat2) {
            return new Long(jobStat.start).compareTo(jobStat2.start);
        }
    };
    static final Comparator<JobStat> RESULTSIZE = new Comparator<JobStat>(){

        @Override
        public int compare(JobStat jobStat, JobStat jobStat2) {
            return new Long(jobStat2.resultSize).compareTo(jobStat.resultSize);
        }
    };
    private static DateFormat DATE_TIME = SimpleDateFormat.getDateTimeInstance(2, 2, Locale.UK);
    Services webService;
    String clusterJobId;
    String jobname;
    long start;
    long finish;
    long inputSize;
    long resultSize;
    boolean isCollected;
    boolean isCancelled;

    private JobStat(Services services, String string, String string2, long l, long l2, long l3, long l4, boolean bl, boolean bl2) {
        this.webService = services;
        this.clusterJobId = string;
        this.jobname = string2;
        this.start = l;
        this.finish = l2;
        this.inputSize = l3;
        this.resultSize = l4;
        this.isCancelled = bl;
        this.isCollected = bl2;
        this.validate();
    }

    public static JobStat newInstance(Services services, String string, String string2, long l, long l2, long l3, long l4, boolean bl, boolean bl2) {
        return new JobStat(services, string, string2, l, l2, l3, l4, bl, bl2);
    }

    public static JobStat newInstance(Services services, String string, String string2, Timestamp timestamp, Timestamp timestamp2, long l, long l2, boolean bl, boolean bl2) {
        long l3 = -1L;
        long l4 = -1L;
        if (timestamp != null) {
            l3 = timestamp.getTime();
        }
        if (timestamp2 != null) {
            l4 = timestamp2.getTime();
        }
        return new JobStat(services, string, string2, l3, l4, l, l2, bl, bl2);
    }

    void validate() {
        if (this.webService == null) {
            throw new AssertionError((Object)("webService must be defined!:\n " + this));
        }
        if (Util.isEmpty(this.jobname)) {
            throw new AssertionError((Object)("jobname must be defined!:\n" + this));
        }
    }

    private JobStat(String string) {
        assert (!Util.isEmpty(this.jobname));
        this.jobname = string;
    }

    public static JobStat newIncompleteStat(String string) {
        return new JobStat(string);
    }

    public boolean isClusterJob() {
        return this.jobname.startsWith("@");
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.jobname == null ? 0 : this.jobname.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JobStat jobStat = (JobStat)object;
        return !(this.jobname == null ? jobStat.jobname != null : !this.jobname.equals(jobStat.jobname));
    }

    public int getRuntime() {
        if (this.start != -1L && this.finish != -1L) {
            return (int)(this.finish - this.start) / 1000;
        }
        return -1;
    }

    public String toString() {
        return this.getJobReport();
    }

    String getJobReport() {
        String string = "WS: " + (Object)((Object)this.webService) + "\n";
        string = string + "JOB: " + this.jobname + "\n";
        if (this.start != -1L) {
            string = string + "Started " + new Date(this.start) + "\n";
        }
        if (this.finish != -1L) {
            string = string + "Finished " + new Date(this.finish) + "\n";
        }
        if (this.start != -1L && this.finish != -1L) {
            string = string + "Runtime " + this.getRuntime() + "\n";
        }
        string = string + "Input size " + this.inputSize + "\n";
        string = string + "Result size " + this.resultSize + "\n";
        string = string + "ClusterJobID " + this.clusterJobId + "\n";
        string = string + "Collected? " + this.isCollected + "\n";
        string = string + "Cancelled? " + this.isCancelled + "\n";
        return string;
    }

    String getJobReportTabulated() {
        String string = (Object)((Object)this.webService) + "\t";
        string = string + this.jobname + "\t";
        string = this.start != -1L ? string + ExecutionStatCollector.DF.format(new Date(this.start)) + "\t" : string + "-1\t";
        string = this.finish != -1L ? string + ExecutionStatCollector.DF.format(new Date(this.finish)) + "\t" : string + "-1\t";
        string = this.start != -1L && this.finish != -1L ? string + this.getRuntime() + "\t" : string + "-1\t";
        string = string + this.inputSize + "\t";
        string = string + this.resultSize + "\t";
        string = string + this.clusterJobId + "\t";
        string = string + this.isCollected + "\t";
        string = string + this.isCancelled + "\t";
        return string;
    }

    public Services getWebService() {
        return this.webService;
    }

    public String getClusterJobId() {
        return this.clusterJobId;
    }

    public String getJobname() {
        return this.jobname;
    }

    public String getEscJobname() {
        String[] stringArray = this.jobname.split("#");
        return stringArray[0] + "%23" + stringArray[1];
    }

    public String getStart() {
        if (this.start != -1L) {
            return DATE_TIME.format(new Date(this.start));
        }
        return "?";
    }

    public long getNumericalStart() {
        return this.start;
    }

    public long getNumericalFinish() {
        return this.finish;
    }

    public String getFinish() {
        if (this.finish != -1L) {
            return DATE_TIME.format(new Date(this.finish));
        }
        return "?";
    }

    public long getInputSize() {
        if (this.inputSize != -1L) {
            return this.inputSize;
        }
        return 0L;
    }

    public long getResultSize() {
        if (this.resultSize > 0L) {
            return this.resultSize;
        }
        return 0L;
    }

    public boolean hasResult() {
        return this.resultSize > 0L;
    }

    public boolean hasStarted() {
        return this.start != -1L;
    }

    public boolean getIsCollected() {
        return this.isCollected;
    }

    public boolean getIsCancelled() {
        return this.isCancelled;
    }

    public boolean getIsFinished() {
        return this.finish != -1L;
    }
}

