/*
 * Decompiled with CFR 0.152.
 */
package compbio.stat.collector;

import compbio.engine.conf.PropertyHelperManager;
import compbio.stat.collector.JobStat;
import compbio.util.Util;
import compbio.ws.client.Services;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class StatDB {
    private static final String driver = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String protocol = "jdbc:derby:";
    private static final String statDBName = "ExecutionStatistic";
    private static final Logger log = Logger.getLogger(StatDB.class);
    static Connection conn;

    private static synchronized Connection getDBConnection() throws SQLException {
        if (conn != null && !conn.isClosed()) {
            return conn;
        }
        try {
            String string = PropertyHelperManager.getLocalPath();
            log.info("Looking for JABAWS access statistics database at: " + string);
            System.setProperty("derby.system.home", string);
            Class.forName(driver);
            conn = DriverManager.getConnection("jdbc:derby:ExecutionStatistic;create=false");
            conn.setAutoCommit(true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.error(classNotFoundException.getMessage(), classNotFoundException);
        }
        return conn;
    }

    public StatDB() throws SQLException {
        conn = this.getDBConnection();
    }

    StatDB(boolean bl) throws SQLException {
        conn = this.getTestDBConnection();
    }

    private static Connection getTestDBConnection() throws SQLException {
        System.setProperty("derby.system.home", "testsrc/testdata");
        Connection connection = DriverManager.getConnection("jdbc:derby:ExecutionStatistic;create=false");
        connection.setAutoCommit(true);
        log.debug("Connecting to the TEST database!");
        return connection;
    }

    private void createStatTable() throws SQLException {
        Statement statement = conn.createStatement();
        String string = "create table exec_stat(number INT GENERATED ALWAYS AS IDENTITY,service_name VARCHAR(15) NOT NULL, cluster_job_id VARCHAR(30), job_id VARCHAR(35) NOT NULL PRIMARY KEY, start TIMESTAMP,finish TIMESTAMP,inputsize BIGINT,resultsize BIGINT,isCancelled SMALLINT NOT NULL,isCollected SMALLINT NOT NULL, isClusterJob SMALLINT NOT NULL)";
        log.debug(string);
        statement.execute(string);
        statement.close();
        conn.close();
    }

    static void clearStatTable() throws SQLException {
        Connection connection = StatDB.getDBConnection();
        String string = "delete from exec_stat";
        Statement statement = connection.createStatement();
        statement.executeUpdate(string);
        statement.close();
        connection.commit();
        connection.close();
    }

    void insertData(Set<JobStat> set) throws SQLException {
        log.info("Inserting " + set.size() + " new records into the statistics database");
        conn.setAutoCommit(false);
        String string = "insert into exec_stat (service_name, cluster_job_id, job_id, start, finish, inputsize, resultsize, isCancelled, isCollected, isClusterJob) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = conn.prepareStatement(string);
        for (JobStat jobStat : set) {
            preparedStatement.setString(1, jobStat.webService.toString());
            if (!Util.isEmpty(jobStat.clusterJobId)) {
                preparedStatement.setString(2, jobStat.clusterJobId);
            } else {
                preparedStatement.setString(2, null);
            }
            preparedStatement.setString(3, jobStat.jobname);
            if (jobStat.start != -1L) {
                preparedStatement.setTimestamp(4, new Timestamp(jobStat.start));
            } else {
                preparedStatement.setTimestamp(4, null);
            }
            if (jobStat.finish != -1L) {
                preparedStatement.setTimestamp(5, new Timestamp(jobStat.finish));
            } else {
                preparedStatement.setTimestamp(5, null);
            }
            preparedStatement.setLong(6, jobStat.inputSize);
            preparedStatement.setLong(7, jobStat.resultSize);
            preparedStatement.setBoolean(8, jobStat.isCancelled);
            preparedStatement.setBoolean(9, jobStat.isCollected);
            preparedStatement.setBoolean(10, jobStat.isClusterJob());
            preparedStatement.executeUpdate();
        }
        conn.commit();
        conn.setAutoCommit(true);
        preparedStatement.close();
    }

    public Date getEarliestRecord() throws SQLException {
        String string = "select min(start) from exec_stat";
        Statement statement = conn.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        boolean bl = resultSet.next();
        Date date = new Date();
        if (bl) {
            date = resultSet.getDate(1);
        }
        resultSet.close();
        statement.close();
        return date;
    }

    public int getTotalJobsCount(Timestamp timestamp, Timestamp timestamp2) throws SQLException {
        String string = "select count(*) from exec_stat where start BETWEEN ? and ? ";
        return this.getIntResult(timestamp, timestamp2, string);
    }

    public int getCancelledCount(Timestamp timestamp, Timestamp timestamp2) throws SQLException {
        String string = "select count(*) from exec_stat where start BETWEEN ? and ?  and  isCancelled=1 ";
        return this.getIntResult(timestamp, timestamp2, string);
    }

    public int getAbandonedCount(Timestamp timestamp, Timestamp timestamp2) throws SQLException {
        String string = "select count(*) from exec_stat where start BETWEEN ? and ? and isCollected=0 and isCancelled=0 and resultsize>0 ";
        return this.getIntResult(timestamp, timestamp2, string);
    }

    public int getIncompleteCount(Timestamp timestamp, Timestamp timestamp2) throws SQLException {
        String string = "select count(*) from exec_stat where start BETWEEN ? and ? and resultsize<=0 and isCancelled=0";
        return this.getIntResult(timestamp, timestamp2, string);
    }

    private int getIntResult(Timestamp timestamp, Timestamp timestamp2, String string) throws SQLException {
        log.debug("getIntRes: QUERY: " + string);
        log.debug("getIntRes: FROM: " + timestamp);
        log.debug("getIntRes: TO: " + timestamp2);
        PreparedStatement preparedStatement = conn.prepareStatement(string);
        preparedStatement.setTimestamp(1, timestamp);
        preparedStatement.setTimestamp(2, timestamp2);
        preparedStatement.execute();
        ResultSet resultSet = preparedStatement.getResultSet();
        boolean bl = resultSet.next();
        int n = 0;
        if (bl) {
            n = resultSet.getInt(1);
        }
        log.debug("getIntRes: RES: " + n);
        resultSet.close();
        preparedStatement.close();
        return n;
    }

    public List<JobStat> readData(Timestamp timestamp, Timestamp timestamp2, Services services, Boolean bl) throws SQLException {
        String string = "select service_name, cluster_job_id, job_id, start, finish, inputsize, resultsize, isCancelled, isCollected from exec_stat where start BETWEEN ? and ? ";
        if (services != null) {
            string = string + " and service_name=? ";
        }
        if (bl != null) {
            string = bl != false ? string + " and isClusterJob!=0 " : string + " and isClusterJob=0 ";
        }
        log.debug("QUERY: " + string);
        log.debug("FROM: " + timestamp);
        log.debug("TO: " + timestamp2);
        log.debug("WS: " + (Object)((Object)services));
        PreparedStatement preparedStatement = conn.prepareStatement(string);
        preparedStatement.setTimestamp(1, timestamp);
        preparedStatement.setTimestamp(2, timestamp2);
        if (services != null) {
            preparedStatement.setString(3, services.toString());
        }
        preparedStatement.execute();
        ArrayList<JobStat> arrayList = new ArrayList<JobStat>();
        ResultSet resultSet = preparedStatement.getResultSet();
        int n = 0;
        while (resultSet.next()) {
            ++n;
            arrayList.add(JobStat.newInstance(Services.getService(resultSet.getString(1)), resultSet.getString(2), resultSet.getString(3), resultSet.getTimestamp(4), resultSet.getTimestamp(5), resultSet.getLong(6), resultSet.getLong(7), resultSet.getBoolean(8), resultSet.getBoolean(9)));
        }
        log.debug("QUERY result len: " + n);
        resultSet.close();
        preparedStatement.close();
        return arrayList;
    }

    public void removeRecordedJobs(Set<JobStat> set) throws SQLException {
        String string = "select job_id from exec_stat";
        Statement statement = conn.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            String string2 = resultSet.getString(1);
            JobStat jobStat = JobStat.newIncompleteStat(string2);
            if (!set.contains(jobStat)) continue;
            set.remove(jobStat);
        }
        resultSet.close();
        statement.close();
    }

    public static final synchronized void shutdownDBServer() {
        boolean bl;
        block7: {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {
                log.warn("Database commit failed with " + sQLException.getLocalizedMessage());
            }
            bl = false;
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sQLException) {
                if (!sQLException.getSQLState().equals("XJ015")) break block7;
                bl = true;
            }
        }
        if (!bl) {
            log.warn("Database did not shut down normally");
        } else {
            log.info("Database shut down normally");
        }
    }

    public static void main(String[] stringArray) {
        try {
            StatDB.clearStatTable();
            StatDB.shutdownDBServer();
        }
        catch (SQLException sQLException) {
            System.err.println("Fails to clean up JABAWS stat database!");
            sQLException.printStackTrace();
        }
    }
}

