/*
 * Decompiled with CFR 0.152.
 */
package compbio.stat.servlet;

import compbio.stat.servlet.util.StatCollection;
import compbio.stat.servlet.util.Totals;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class DisplayStat
extends HttpServlet {
    private static final Logger log = Logger.getLogger(DisplayStat.class);

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("datetime");
        Date date = new Date(Long.parseLong(string));
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        try {
            StatCollection statCollection = StatCollection.newStatCollecton(date, calendar.getTime());
            log.trace("Stats: " + statCollection);
            httpServletRequest.setAttribute("stat", (Object)statCollection);
            httpServletRequest.setAttribute("statTotal", (Object)Totals.sumStats(statCollection.getAllStat()));
            httpServletRequest.setAttribute("statTotalCluster", (Object)Totals.sumStats(statCollection.getClusterStat()));
            httpServletRequest.setAttribute("statTotalLocal", (Object)Totals.sumStats(statCollection.getLocalStat()));
            httpServletRequest.setAttribute("startDate", (Object)date);
            httpServletRequest.setAttribute("stopDate", (Object)calendar.getTime());
            log.trace("from " + date + "  to " + calendar.getTime());
            RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher("statpages/Statistics.jsp");
            requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (SQLException sQLException) {
            log.error(sQLException.getMessage(), sQLException);
            throw new ServletException((Throwable)sQLException);
        }
    }
}

