/*
 * Decompiled with CFR 0.152.
 */
package compbio.stat.servlet;

import compbio.engine.client.PathValidator;
import compbio.stat.collector.StatDB;
import compbio.stat.collector.StatProcessor;
import compbio.stat.servlet.StatisticCollector;
import compbio.util.Util;
import compbio.ws.client.Services;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class Joblist
extends HttpServlet {
    static final String JT_FAILED = "failed";
    static final String JT_ABANDONED = "abandoned";
    static final String JT_CANCELLED = "cancelled";
    static final String JT_ALL = "all";
    static final String JT_INCOMPLETE = "incomplete";

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("ws");
        Services services = Services.getService(string);
        if (services == null) {
            throw new ServletException("Webservice name 'ws' is not specified or is incorrect. Given value:" + string);
        }
        String string2 = httpServletRequest.getParameter("where");
        if (Util.isEmpty(string2)) {
            throw new ServletException("'Where' is not specified!");
        }
        if (!(string2.equalsIgnoreCase("everywhere") || string2.equalsIgnoreCase("local") || string2.equalsIgnoreCase("cluster"))) {
            throw new ServletException("Invalid 'where' value '" + string2 + "' can be one of 'everywhere', 'local', 'cluster'!");
        }
        Boolean bl = null;
        if (string2.equalsIgnoreCase("local")) {
            bl = false;
        } else if (string2.equalsIgnoreCase("cluster")) {
            bl = true;
        }
        String string3 = httpServletRequest.getParameter("type");
        if (Util.isEmpty(string2)) {
            throw new ServletException("'type' is not specified!");
        }
        if (!(string3.equalsIgnoreCase(JT_CANCELLED) || string3.equalsIgnoreCase(JT_ALL) || string3.equalsIgnoreCase(JT_INCOMPLETE) || string3.equalsIgnoreCase(JT_ABANDONED) || string3.equalsIgnoreCase(JT_FAILED))) {
            throw new ServletException("Invalid 'jobtype' value '" + string3 + "' can be one of 'cancelled', 'all', 'incomplete', " + "'failed', 'abandoned'!");
        }
        String string4 = httpServletRequest.getParameter("from");
        if (Util.isEmpty(string4)) {
            throw new ServletException("'fromDate' is not specified!");
        }
        String string5 = httpServletRequest.getParameter("to");
        if (Util.isEmpty(string5)) {
            throw new ServletException("'toDate' is not specified!");
        }
        String string6 = StatisticCollector.getClusterJobDir();
        string6 = !Util.isEmpty(string6) ? new File(string6).getName() : "";
        String string7 = StatisticCollector.getLocalJobDir();
        if (!Util.isEmpty(string7)) {
            if (PathValidator.isAbsolutePath(string7)) {
                string7 = new File(string7).getName();
            }
        } else {
            string7 = "";
        }
        Timestamp timestamp = new Timestamp(Long.parseLong(string4));
        Timestamp timestamp2 = new Timestamp(Long.parseLong(string5));
        StatDB statDB = null;
        try {
            statDB = new StatDB();
            StatProcessor statProcessor = new StatProcessor(statDB.readData(timestamp, timestamp2, services, bl));
            HttpSession httpSession = httpServletRequest.getSession();
            if (string3.equalsIgnoreCase(JT_CANCELLED)) {
                httpSession.setAttribute("stat", (Object)new StatProcessor(statProcessor.getCancelledJobs()));
            } else if (string3.equalsIgnoreCase(JT_INCOMPLETE)) {
                httpSession.setAttribute("stat", (Object)new StatProcessor(statProcessor.getIncompleteJobs()));
            } else if (string3.equalsIgnoreCase(JT_ALL)) {
                httpSession.setAttribute("stat", (Object)statProcessor);
            } else if (string3.equalsIgnoreCase(JT_FAILED)) {
                httpSession.setAttribute("stat", (Object)new StatProcessor(statProcessor.getFailedJobs()));
            } else if (string3.equalsIgnoreCase(JT_ABANDONED)) {
                httpSession.setAttribute("stat", (Object)new StatProcessor(statProcessor.getAbandonedJobs()));
            } else {
                throw new AssertionError((Object)("Unrecognised job type: " + string3));
            }
            httpSession.setAttribute("clusterTemp", (Object)string6);
            httpSession.setAttribute("localTemp", (Object)string7);
            httpServletRequest.setAttribute("startDate", (Object)timestamp.getTime());
            httpServletRequest.setAttribute("stopDate", (Object)timestamp2.getTime());
            RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher("statpages/Joblist.jsp");
            requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new ServletException("SQLException : " + sQLException.getLocalizedMessage(), (Throwable)sQLException);
        }
    }
}

