/*
 * Decompiled with CFR 0.152.
 */
package compbio.stat.servlet;

import compbio.engine.conf.PropertyHelperManager;
import compbio.stat.servlet.ServiceTestResult;
import compbio.stat.servlet.util.RefreshIterator;
import compbio.stat.servlet.util.Scheduler;
import compbio.stat.servlet.util.SchedulerTask;
import compbio.util.PropertyHelper;
import compbio.util.Util;
import compbio.ws.client.Services;
import compbio.ws.client.WSTester;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.ReflectionException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ServiceStatus
extends HttpServlet {
    private static final Logger log = Logger.getLogger(ServiceStatus.class);
    private static PropertyHelper ph = PropertyHelperManager.getPropertyHelper();
    private final Scheduler scheduler = new Scheduler();

    private List<String> getEndPoints() throws MalformedObjectNameException, NullPointerException, UnknownHostException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> set = mBeanServer.queryNames(new ObjectName("*:type=Connector,*"), Query.match(Query.attr("protocol"), Query.value("HTTP/1.1")));
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ObjectName objectName : set) {
            String string = mBeanServer.getAttribute(objectName, "scheme").toString();
            String string2 = objectName.getKeyProperty("port");
            String string3 = InetAddress.getLocalHost().getHostName();
            arrayList.add(string + "://" + string3 + ":" + string2);
        }
        return arrayList;
    }

    private static int getIntProperty(String string) {
        int n = 0;
        if (!Util.isEmpty(string)) {
            string = string.trim();
            n = Integer.parseInt(string);
        }
        return n;
    }

    private static int refreshServiceStatusFrequency() {
        return ServiceStatus.getIntProperty(ph.getProperty("local.service.status.refresh.frequency"));
    }

    static int refreshUsageStatsFrequency() {
        return ServiceStatus.getIntProperty(ph.getProperty("local.usage.stats.refresh.frequency"));
    }

    public void init() {
        int n = Calendar.getInstance().get(11);
        int n2 = Calendar.getInstance().get(12);
        int n3 = Calendar.getInstance().get(13);
        final int n4 = ServiceStatus.refreshServiceStatusFrequency();
        this.scheduler.schedule(new SchedulerTask(){

            @Override
            public void run() {
                this.refreshCache();
            }

            private void refreshCache() {
                ServiceStatus.this.hitEndpointForRefresh();
                log.info("Refreshing the In Memory Cache...");
                log.info(String.format("Refreshing again in %d minutes", n4));
            }
        }, new RefreshIterator(n, n2, n3, n4));
    }

    public void clearContextCache() {
        try {
            this.getServletConfig().getServletContext().removeAttribute("serviceStatusResults");
            this.getServletConfig().getServletContext().removeAttribute("serviceStatusTimestamp");
            this.getServletConfig().getServletContext().removeAttribute("serviceStatusStart");
            this.getServletConfig().getServletContext().removeAttribute("serviceStatusEnd");
            this.getServletConfig().getServletContext().removeAttribute("serviceStatusAllGood");
            log.info("In Memory Cache Cleared!");
        }
        catch (Exception exception) {
            log.warn("In Memory Cache Not Cleared. Perhaps not available yet!");
        }
    }

    private void hitEndpointForRefresh() {
        String string = (String)this.getServletConfig().getServletContext().getAttribute("serviceStatusURL");
        if (string != null) {
            try {
                URL uRL = new URL(string);
                System.out.println(string);
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setRequestProperty("User-Agent", "JABAWS Service Status Refreshing the Context Cache");
                int n = httpURLConnection.getResponseCode();
                log.info(String.format("Hitting %s with an internal user-agent! status code: %s", string, n));
            }
            catch (IOException iOException) {
                log.warn("Something wrong when hitting " + string);
                log.warn(iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ServiceTestResult> testServiceStatus(HttpServletRequest httpServletRequest) throws ServletException, IOException {
        ArrayList<ServiceTestResult> arrayList = new ArrayList<ServiceTestResult>();
        List<Object> list = new ArrayList();
        try {
            list = this.getEndPoints();
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            malformedObjectNameException.printStackTrace();
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            attributeNotFoundException.printStackTrace();
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            instanceNotFoundException.printStackTrace();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        catch (MBeanException mBeanException) {
            mBeanException.printStackTrace();
        }
        catch (ReflectionException reflectionException) {
            reflectionException.printStackTrace();
        }
        if (1 != list.size()) {
            log.info(list.size() + "EndPoints found");
            for (String object : list) {
                log.info(list.size() + "EndPoint is " + object);
            }
        }
        Object object = new String();
        for (String string : list) {
            object = string + httpServletRequest.getContextPath();
        }
        for (Services services : Services.values()) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
            WSTester wSTester = new WSTester((String)object, printWriter);
            ServiceTestResult serviceTestResult = new ServiceTestResult(services);
            try {
                serviceTestResult.failed = wSTester.checkService(services);
            }
            catch (Exception exception) {
                log.info(exception, exception.getCause());
                String string = "Fails to connect to the web service: " + (Object)((Object)services) + ". Reason: ";
                printWriter.println(string + exception.getLocalizedMessage() + "\nDetails: ");
                exception.printStackTrace(printWriter);
            }
            finally {
                printWriter.close();
            }
            serviceTestResult.details = stringWriter.toString();
            arrayList.add(serviceTestResult);
        }
        return arrayList;
    }

    public String overallStatusGood(ArrayList<ServiceTestResult> arrayList) {
        String string = "true";
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get((int)i).failed) continue;
            string = "false";
            break;
        }
        return string;
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        long l;
        long l2;
        ArrayList arrayList = new ArrayList();
        String string2 = new String();
        String string3 = new String();
        string3 = httpServletRequest.getRequestURL().toString();
        System.out.println("UR: " + string3);
        this.getServletConfig().getServletContext().setAttribute("serviceStatusURL", (Object)string3);
        String string4 = new String();
        string4 = httpServletRequest.getHeader("user-agent");
        if (this.getServletConfig().getServletContext().getAttribute("serviceStatusResults") == null || string4.equals("JABAWS Service Status Refreshing the Context Cache")) {
            l2 = System.nanoTime();
            arrayList = this.testServiceStatus(httpServletRequest);
            l = System.nanoTime();
            this.clearContextCache();
            this.getServletConfig().getServletContext().setAttribute("serviceStatusResults", (Object)arrayList);
            string2 = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(Calendar.getInstance().getTime());
            this.getServletConfig().getServletContext().setAttribute("serviceStatusTimestamp", (Object)string2);
            this.getServletConfig().getServletContext().setAttribute("serviceStatusStart", (Object)l2);
            this.getServletConfig().getServletContext().setAttribute("serviceStatusEnd", (Object)l);
            string = String.valueOf(ServiceStatus.refreshServiceStatusFrequency());
            this.getServletConfig().getServletContext().setAttribute("serviceStatusRefreshFreq", (Object)string);
            String string5 = this.overallStatusGood(arrayList);
            this.getServletConfig().getServletContext().setAttribute("serviceStatusAllGood", (Object)string5);
        } else {
            arrayList = (ArrayList)this.getServletConfig().getServletContext().getAttribute("serviceStatusResults");
            string2 = (String)this.getServletConfig().getServletContext().getAttribute("serviceStatusTimestamp");
            l2 = (Long)this.getServletConfig().getServletContext().getAttribute("serviceStatusStart");
            l = (Long)this.getServletConfig().getServletContext().getAttribute("serviceStatusEnd");
            string = (String)this.getServletConfig().getServletContext().getAttribute("serviceStatusRefreshFreq");
        }
        httpServletRequest.setAttribute("results", (Object)arrayList);
        httpServletRequest.setAttribute("timestamp", (Object)string2);
        httpServletRequest.setAttribute("timeexec", (Object)((l - l2) / 1000000000L));
        httpServletRequest.setAttribute("refreshfreq", (Object)string);
        RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher("statpages/ServicesStatus.jsp");
        requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }
}

