/*
 * Decompiled with CFR 0.152.
 */
package compbio.stat.servlet;

import compbio.engine.client.EngineUtil;
import compbio.engine.conf.PropertyHelperManager;
import compbio.stat.collector.ExecutionStatCollector;
import compbio.stat.collector.StatDB;
import compbio.util.PropertyHelper;
import compbio.util.Util;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;

public class StatisticCollector
implements ServletContextListener {
    static PropertyHelper ph = PropertyHelperManager.getPropertyHelper();
    private final Logger log = Logger.getLogger(StatisticCollector.class);
    private ScheduledFuture<?> localcf;
    private ScheduledFuture<?> clustercf;
    private ScheduledExecutorService executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        try {
            if (this.localcf != null) {
                this.localcf.cancel(true);
            }
            if (this.clustercf != null) {
                this.clustercf.cancel(true);
            }
            this.executor.shutdown();
            this.executor.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            this.log.warn(interruptedException.getMessage(), interruptedException);
        }
        finally {
            StatDB.shutdownDBServer();
            this.executor.shutdownNow();
        }
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ExecutionStatCollector executionStatCollector;
        long l;
        String string = StatisticCollector.getClusterJobDir();
        int n = StatisticCollector.getClusterJobTimeOut();
        int n2 = StatisticCollector.getLocalJobTimeOut();
        String string2 = EngineUtil.convertToAbsolute(StatisticCollector.getLocalJobDir());
        this.log.info("Initializing statistics collectors");
        this.executor = Executors.newScheduledThreadPool(2);
        if (StatisticCollector.collectClusterStats()) {
            l = StatisticCollector.updateClusterStatsFrequency();
            if (0L == l) {
                l = 1L;
            }
            executionStatCollector = new ExecutionStatCollector(string, n);
            this.clustercf = this.executor.scheduleAtFixedRate(executionStatCollector, 30L, 60L * l, TimeUnit.SECONDS);
            this.log.info("Collecting cluster statistics every " + l + " minutes");
        } else {
            this.log.info("Cluster statistics collector is disabled or not configured! ");
        }
        if (StatisticCollector.collectLocalStats()) {
            l = StatisticCollector.updateLocalStatsFrequency();
            if (0L == l) {
                l = 1L;
            }
            executionStatCollector = new ExecutionStatCollector(string2, n2);
            this.localcf = this.executor.scheduleAtFixedRate(executionStatCollector, 30L, 60L * l, TimeUnit.SECONDS);
            this.log.info("Collecting local statistics every " + l + " minutes");
        } else {
            this.log.info("Local statistics collector is disabled or not configured! ");
        }
    }

    static String getClusterJobDir() {
        return StatisticCollector.getStringProperty(ph.getProperty("cluster.tmp.directory"));
    }

    static int getClusterJobTimeOut() {
        int n = 168;
        String string = ph.getProperty("cluster.stat.maxruntime");
        if (string != null) {
            string = string.trim();
            n = Integer.parseInt(string);
        }
        return n;
    }

    static int getLocalJobTimeOut() {
        int n = 24;
        String string = ph.getProperty("local.stat.maxruntime");
        if (string != null) {
            string = string.trim();
            n = Integer.parseInt(string);
        }
        return n;
    }

    static String getLocalJobDir() {
        return StatisticCollector.getStringProperty(ph.getProperty("local.tmp.directory"));
    }

    private static String getStringProperty(String string) {
        if (string != null) {
            string = string.trim();
        }
        return string;
    }

    private static int getIntProperty(String string) {
        int n = 0;
        if (!Util.isEmpty(string)) {
            string = string.trim();
            n = Integer.parseInt(string);
        }
        return n;
    }

    static boolean collectClusterStats() {
        return StatisticCollector.getBooleanProperty(ph.getProperty("cluster.stat.collector.enable"));
    }

    static boolean collectLocalStats() {
        return StatisticCollector.getBooleanProperty(ph.getProperty("local.stat.collector.enable"));
    }

    static int updateClusterStatsFrequency() {
        return StatisticCollector.getIntProperty(ph.getProperty("cluster.stat.collector.update.frequency"));
    }

    static int updateLocalStatsFrequency() {
        return StatisticCollector.getIntProperty(ph.getProperty("local.stat.collector.update.frequency"));
    }

    private static boolean getBooleanProperty(String string) {
        boolean bl = false;
        if (!Util.isEmpty(string)) {
            string = string.trim();
            bl = Boolean.parseBoolean(string);
        }
        return bl;
    }
}

