/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.server;

import compbio.data.msa.SequenceAnnotation;
import compbio.data.sequence.FastaSequence;
import compbio.engine.Configurator;
import compbio.engine.client.ConfiguredExecutable;
import compbio.metadata.ChunkHolder;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.LimitExceededException;
import compbio.metadata.Option;
import compbio.metadata.Preset;
import compbio.metadata.UnsupportedRuntimeException;
import compbio.metadata.WrongParameterException;
import compbio.runner.conservation.AACon;
import compbio.ws.server.SequenceAnnotationService;
import compbio.ws.server.WSUtil;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.jws.WebService;
import org.apache.log4j.Logger;

@WebService(endpointInterface="compbio.data.msa.SequenceAnnotation", targetNamespace="http://msa.data.compbio/01/12/2010/", serviceName="AAConWS")
public class AAConWS
extends SequenceAnnotationService<AACon>
implements SequenceAnnotation<AACon> {
    private static Logger log = Logger.getLogger(AAConWS.class);

    public AAConWS() {
        super(new AACon(), log);
    }

    @Override
    public String analize(List<FastaSequence> list) throws UnsupportedRuntimeException, LimitExceededException, JobSubmissionException {
        WSUtil.validateAAConInput(list);
        ConfiguredExecutable configuredExecutable = this.init(list);
        configuredExecutable.addParameters(Arrays.asList("-m=SHENKIN"));
        return WSUtil.analize(list, configuredExecutable, log, "AAConWS analize", this.getLimit(""));
    }

    @Override
    public String customAnalize(List<FastaSequence> list, List<Option<AACon>> list2) throws UnsupportedRuntimeException, LimitExceededException, JobSubmissionException, WrongParameterException {
        WSUtil.validateAAConInput(list);
        return super.customAnalize(list, list2);
    }

    @Override
    public String presetAnalize(List<FastaSequence> list, Preset<AACon> preset) throws UnsupportedRuntimeException, LimitExceededException, JobSubmissionException, WrongParameterException {
        WSUtil.validateAAConInput(list);
        return super.presetAnalize(list, preset);
    }

    @Override
    public ChunkHolder pullExecStatistics(String string, long l) {
        WSUtil.validateJobId(string);
        String string2 = Configurator.getWorkDirectory(string) + File.separator + AACon.getStatFile();
        return WSUtil.pullFile(string2, l);
    }
}

