/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.server;

import compbio.data.sequence.FastaSequence;
import compbio.engine.Configurator;
import compbio.engine.client.ConfiguredExecutable;
import compbio.engine.client.EngineUtil;
import compbio.engine.client.SkeletalExecutable;
import compbio.metadata.ChunkHolder;
import compbio.metadata.JobStatus;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.Limit;
import compbio.metadata.LimitsManager;
import compbio.metadata.PresetManager;
import compbio.metadata.RunnerConfig;
import compbio.runner.RunnerUtil;
import compbio.ws.server.WSUtil;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class GenericMetadataService<T> {
    private final RunnerConfig<T> aaconOptions;
    private final PresetManager<T> aaconPresets;
    private final LimitsManager<T> limitMan;
    private SkeletalExecutable<T> exec;
    final Logger log;

    GenericMetadataService(SkeletalExecutable<T> skeletalExecutable, Logger logger) {
        assert (logger != null);
        assert (skeletalExecutable != null);
        this.log = logger;
        this.exec = skeletalExecutable;
        this.limitMan = EngineUtil.getLimits(skeletalExecutable.getType());
        this.aaconOptions = RunnerUtil.getSupportedOptions(skeletalExecutable.getType());
        this.aaconPresets = RunnerUtil.getPresets(skeletalExecutable.getType());
    }

    ConfiguredExecutable<T> init(List<FastaSequence> list) throws JobSubmissionException {
        try {
            this.exec = (SkeletalExecutable)this.exec.getType().newInstance();
        }
        catch (InstantiationException instantiationException) {
            this.log.error(instantiationException.getLocalizedMessage(), instantiationException);
            throw new JobSubmissionException(instantiationException.getLocalizedMessage(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.log.error(illegalAccessException.getLocalizedMessage(), illegalAccessException);
            throw new JobSubmissionException(illegalAccessException.getLocalizedMessage(), illegalAccessException);
        }
        this.exec.setInput("input.txt").setOutput("result.txt").setError("error.txt");
        return Configurator.configureExecutable(this.exec, list);
    }

    public boolean cancelJob(String string) {
        WSUtil.validateJobId(string);
        return WSUtil.cancelJob(string);
    }

    public JobStatus getJobStatus(String string) {
        WSUtil.validateJobId(string);
        return WSUtil.getJobStatus(string);
    }

    public Limit<T> getLimit(String string) {
        if (this.limitMan == null) {
            return null;
        }
        return this.limitMan.getLimitByName(string);
    }

    public LimitsManager<T> getLimits() {
        return this.limitMan;
    }

    public PresetManager<T> getPresets() {
        return this.aaconPresets;
    }

    public RunnerConfig<T> getRunnerOptions() {
        return this.aaconOptions;
    }

    public ChunkHolder pullExecStatistics(String string, long l) {
        return new ChunkHolder("", -1L);
    }
}

