/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.server;

import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.ScoreManager;
import compbio.engine.client.ConfiguredExecutable;
import compbio.engine.client.SkeletalExecutable;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.Limit;
import compbio.metadata.LimitExceededException;
import compbio.metadata.Option;
import compbio.metadata.Preset;
import compbio.metadata.ResultNotAvailableException;
import compbio.metadata.UnsupportedRuntimeException;
import compbio.metadata.WrongParameterException;
import compbio.ws.server.GenericMetadataService;
import compbio.ws.server.WSUtil;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class SequenceAnnotationService<T>
extends GenericMetadataService {
    SequenceAnnotationService(SkeletalExecutable<T> skeletalExecutable, Logger logger) {
        super(skeletalExecutable, logger);
    }

    public ScoreManager getAnnotation(String string) throws ResultNotAvailableException {
        return WSUtil.getAnnotation(string, this.log);
    }

    public String analize(List<FastaSequence> list) throws UnsupportedRuntimeException, LimitExceededException, JobSubmissionException {
        WSUtil.validateFastaInput(list);
        ConfiguredExecutable configuredExecutable = this.init(list);
        return WSUtil.analize(list, configuredExecutable, this.log, "analize", this.getLimit(""));
    }

    public String customAnalize(List<FastaSequence> list, List<Option<T>> list2) throws UnsupportedRuntimeException, LimitExceededException, JobSubmissionException, WrongParameterException {
        WSUtil.validateFastaInput(list);
        ConfiguredExecutable configuredExecutable = this.init(list);
        List<String> list3 = WSUtil.getCommands(list2, "=");
        configuredExecutable.addParameters(list3);
        return WSUtil.analize(list, configuredExecutable, this.log, "customAnalize", this.getLimit(""));
    }

    public String presetAnalize(List<FastaSequence> list, Preset<T> preset) throws UnsupportedRuntimeException, LimitExceededException, JobSubmissionException, WrongParameterException {
        WSUtil.validateAAConInput(list);
        if (preset == null) {
            throw new WrongParameterException("Preset must be provided!");
        }
        ConfiguredExecutable configuredExecutable = this.init(list);
        configuredExecutable.addParameters(preset.getOptions());
        Limit limit = this.getLimit(preset.getName());
        return WSUtil.analize(list, configuredExecutable, this.log, "presetAnalize", limit);
    }
}

