/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.server;

import compbio.engine.client.EngineUtil;
import compbio.engine.client.Executable;
import compbio.engine.conf.PropertyHelperManager;
import compbio.runner.disorder.IUPred;
import compbio.runner.msa.Muscle;
import compbio.util.SysPrefs;
import compbio.util.Util;
import java.io.File;
import java.io.IOException;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;

public class SetExecutableFlag
implements ServletContextListener {
    private final Logger log = Logger.getLogger(SetExecutableFlag.class);

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        Object object;
        String string = EngineUtil.getCommand(Executable.ExecProvider.Local, Muscle.class);
        if (Util.isEmpty(string)) {
            string = EngineUtil.getCommand(Executable.ExecProvider.Local, IUPred.class);
        }
        boolean bl = true;
        if (!Util.isEmpty(string)) {
            object = new File(string);
            bl = ((File)object).canExecute();
        }
        object = PropertyHelperManager.getLocalPath() + "binaries/src";
        String string2 = "setexecflag.sh";
        if (!SysPrefs.isWindows && !bl) {
            File file = new File((String)object, string2);
            if (!file.exists()) {
                this.log.debug("Setexecflag.sh script is NOT found in " + file.getAbsolutePath());
                return;
            }
            file.setExecutable(true);
            this.log.debug("Setexecflag.sh script is found");
            try {
                this.log.debug("Executable flag is NOT set for the binaries - attemping to set it");
                ProcessBuilder processBuilder = new ProcessBuilder(file.getAbsolutePath());
                processBuilder.directory(new File((String)object));
                Process process = processBuilder.start();
                process.waitFor();
                process.destroy();
            }
            catch (IOException iOException) {
                this.log.debug("Failed to execute set executable flag script due to IOException! Please run it manually!");
                this.log.debug(iOException.getMessage(), iOException);
            }
            catch (InterruptedException interruptedException) {
                this.log.debug("Failed to execute set executable flag script due to Interruption! Please run it manually!");
            }
        } else {
            this.log.debug("Executable flag is already set for the binaries.");
        }
    }
}

