/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.sequence;

import compbio.data.sequence.RNAStructScoreManager;
import compbio.data.sequence.Range;
import compbio.data.sequence.Score;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class RNAStructReader {
    static String s = "[+\\s=]+";
    static String bracket = "\\(|\\)|\\{|\\}|\\[|\\]";
    static String notData = "[\\s=+]+";
    static String seqP = "[_\\-a-zA-Z]{2,}";
    static String structP = "[\\.)({}\\[\\],]{2,}";
    static String floatP = "-?\\d+\\.\\d*(e[+\\-]\\d+)?";
    static String energyP = "-?[0-9]*\\.?[0-9]{2}";
    static String freqP = "^-?\\d\\.\\d{6,}(e[+\\-]\\d+)?$";
    static String ps = "\\s*";
    static String alignmentP = "^" + seqP + ps + "$";
    static String mfeStructP = "^" + structP + s + "\\(" + ps + floatP + s + floatP + s + floatP + ps + "\\)" + ps + "$";
    static String justStructP = "^" + structP + ps + "$";
    static String stochBTStructP = "^" + structP + s + floatP + s + floatP + ps + "$";
    static String PStructP = "^" + structP + s + "\\[" + ps + floatP + ps + "\\]" + ps + "$";
    static String centStructP = "^" + structP + s + floatP + ps + "\\{" + ps + floatP + s + floatP + ps + "\\}" + ps + "$";
    static String MEAStructP = "^" + structP + s + "\\{" + ps + floatP + s + "MEA=" + floatP + ps + "\\}" + ps + "$";
    static String freeEnergyP = "^" + ps + "free energy of ensemble" + ps + "=" + ps + floatP + ps + "kcal/mol" + ps + "$";
    static String ensembleFreqP = "^" + ps + "frequency of mfe structure in ensemble " + floatP + ps + "$";

    public static RNAStructScoreManager readRNAStructStream(InputStream inputStream) throws IOException {
        String string = "Error in parsing alifold stdout file: ";
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<TreeSet<Score>> arrayList2 = new ArrayList<TreeSet<Score>>();
        ArrayList<Float> arrayList3 = new ArrayList<Float>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string2 = bufferedReader.readLine();
        assert (Pattern.matches(AlifoldLine.alignment.regex, string2)) : string + "Sequence Alignment Expected";
        arrayList.add(string2.trim());
        arrayList2.add(RNAStructReader.newEmptyScore(AlifoldResult.consensusAlignment));
        string2 = bufferedReader.readLine();
        assert (Pattern.matches(AlifoldLine.mfeStruct.regex, string2)) : string + "Consensus Structure and Energy Expected";
        Scanner scanner = new Scanner(string2);
        arrayList.add(scanner.next());
        for (int i = 0; i < 3; ++i) {
            arrayList3.add(Float.valueOf(Float.parseFloat(scanner.findInLine(floatP))));
        }
        arrayList2.add(RNAStructReader.newSetScore(AlifoldResult.mfeStructure, arrayList3));
        string2 = bufferedReader.readLine();
        Scanner scanner2 = null;
        while (string2 != null) {
            int n;
            arrayList3.clear();
            AlifoldLine alifoldLine = RNAStructReader.identifyLine(string2);
            String string3 = bufferedReader.readLine();
            scanner = new Scanner(string2);
            if (string3 != null) {
                scanner2 = new Scanner(string3);
            }
            if (alifoldLine.equals((Object)AlifoldLine.PStruct)) {
                assert (string3 != null && Pattern.matches(AlifoldLine.ensembleFreq.regex, string3)) : string + "Expected frequency of mfe structure";
                arrayList.add(scanner.next());
                arrayList3.add(Float.valueOf(Float.parseFloat(scanner.findInLine(floatP))));
                arrayList3.add(Float.valueOf(Float.parseFloat(scanner2.findInLine(floatP))));
                arrayList2.add(RNAStructReader.newSetScore(AlifoldResult.contactProbabilityStructure, arrayList3));
                string3 = bufferedReader.readLine();
            } else if (alifoldLine.equals((Object)AlifoldLine.centStruct)) {
                arrayList.add(scanner.next());
                for (n = 0; n < 3; ++n) {
                    arrayList3.add(Float.valueOf(Float.parseFloat(scanner.findInLine(floatP))));
                }
                arrayList2.add(RNAStructReader.newSetScore(AlifoldResult.centroidStructure, arrayList3));
            } else if (alifoldLine.equals((Object)AlifoldLine.MEAStruct)) {
                arrayList.add(scanner.next());
                for (n = 0; n < 2; ++n) {
                    arrayList3.add(Float.valueOf(Float.parseFloat(scanner.findInLine(floatP))));
                }
                arrayList2.add(RNAStructReader.newSetScore(AlifoldResult.MEAStucture, arrayList3));
            } else if (alifoldLine.equals((Object)AlifoldLine.justStruct)) {
                arrayList.add(scanner.next());
                arrayList2.add(RNAStructReader.newEmptyScore(AlifoldResult.stochBTStructure));
            } else if (alifoldLine.equals((Object)AlifoldLine.stochBTStruct)) {
                arrayList.add(scanner.next());
                arrayList3.add(Float.valueOf(scanner.nextFloat()));
                arrayList3.add(Float.valueOf(scanner.nextFloat()));
                arrayList2.add(RNAStructReader.newSetScore(AlifoldResult.stochBTStructure, arrayList3));
            } else if (alifoldLine.equals((Object)AlifoldLine.freeEnergy)) {
                assert (string3 != null && Pattern.matches(AlifoldLine.ensembleFreq.regex, string3)) : string + "Found 'freeEnergy' line on its own";
                arrayList.add("Free energy of ensemble (kcal/mol) followed by frequency of mfe structure in ensemble");
                arrayList3.add(Float.valueOf(Float.parseFloat(scanner.findInLine(floatP))));
                arrayList3.add(Float.valueOf(Float.parseFloat(scanner2.findInLine(floatP))));
                arrayList2.add(RNAStructReader.newSetScore(AlifoldResult.ensembleValues, arrayList3));
                string3 = bufferedReader.readLine();
            }
            assert (!alifoldLine.equals((Object)AlifoldLine.ensembleFreq)) : string + "Wasn't expecting 'frequency of mfe structure'!";
            assert (!alifoldLine.equals((Object)AlifoldLine.mfeStruct)) : string + "'Standard output' line at a place other than line 2!";
            assert (!alifoldLine.equals((Object)AlifoldLine.alignment)) : string + "Wasn't expecting an alignment sequence!";
            assert (!alifoldLine.equals((Object)AlifoldLine.OTHER)) : string + "Wasn't expecting this whatever it is: " + string2;
            string2 = string3;
        }
        scanner.close();
        if (scanner2 != null) {
            scanner2.close();
        }
        return new RNAStructScoreManager(arrayList, arrayList2);
    }

    private static TreeSet<Score> newSetScore(Enum<?> enum_, List<Float> list) {
        float[] fArray = new float[list.size()];
        for (int i = 0; i < fArray.length; ++i) {
            Float f = list.get(i);
            fArray[i] = f != null ? f.floatValue() : Float.NaN;
        }
        return new TreeSet<Score>(Arrays.asList(new Score(enum_, fArray)));
    }

    public static TreeSet<Score> newEmptyScore(Enum<?> enum_) {
        return new TreeSet<Score>(Arrays.asList(new Score(enum_, new float[0])));
    }

    public static RNAStructScoreManager readRNAStructStream(InputStream inputStream, InputStream inputStream2) throws IOException {
        RNAStructScoreManager rNAStructScoreManager = RNAStructReader.readRNAStructStream(inputStream);
        List<String> list = rNAStructScoreManager.getStructs();
        List<TreeSet<Score>> list2 = rNAStructScoreManager.getData();
        Scanner scanner = new Scanner(inputStream2);
        scanner.useDelimiter("[\\s%]+");
        scanner.nextLine();
        scanner.nextLine();
        ArrayList<Float> arrayList = new ArrayList<Float>();
        ArrayList<Range> arrayList2 = new ArrayList<Range>();
        String string = "null";
        while (!Pattern.matches("^[\\.)(]{2,}$", string = scanner.next()) && scanner.hasNextLine()) {
            int n = scanner.nextInt();
            arrayList2.add(new Range(Integer.parseInt(string), n));
            scanner.next();
            arrayList.add(Float.valueOf(scanner.nextFloat()));
            scanner.nextLine();
        }
        scanner.close();
        assert (arrayList2.size() == arrayList.size());
        TreeSet<Score> treeSet = new TreeSet<Score>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            ArrayList<Float> arrayList3 = new ArrayList<Float>(Arrays.asList((Float)arrayList.get(i)));
            TreeSet<Range> treeSet2 = new TreeSet<Range>(Arrays.asList((Range)arrayList2.get(i)));
            treeSet.add(new Score(AlifoldResult.contactProbabilities, arrayList3, treeSet2));
        }
        list2.set(0, treeSet);
        return new RNAStructScoreManager(list, list2);
    }

    private static RNAOut identify(String string) {
        if (Pattern.matches(seqP, string)) {
            return RNAOut.SEQ;
        }
        if (Pattern.matches(structP, string)) {
            return RNAOut.STRUCT;
        }
        if (Pattern.matches(energyP, string)) {
            return RNAOut.ENERGY;
        }
        if (Pattern.matches(freqP, string)) {
            return RNAOut.FREQ;
        }
        return RNAOut.OTHER;
    }

    private static AlifoldLine identifyLine(String string) {
        for (AlifoldLine alifoldLine : AlifoldLine.values()) {
            if (!Pattern.matches(alifoldLine.regex, string)) continue;
            return alifoldLine;
        }
        return AlifoldLine.OTHER;
    }

    public static void main(String[] stringArray) {
        for (AlifoldLine alifoldLine : AlifoldLine.values()) {
            System.out.println(alifoldLine.toString() + ": " + alifoldLine.regex.replace("^", "").replace("$", ""));
        }
    }

    public static enum AlifoldResult {
        mfeStructure,
        contactProbabilityStructure,
        MEAStucture,
        centroidStructure,
        stochBTStructure,
        consensusAlignment,
        ensembleValues,
        contactProbabilities;

    }

    static enum RNAOut {
        SEQ,
        STRUCT,
        ENERGY,
        FREQ,
        OTHER;

    }

    static enum AlifoldLine {
        mfeStruct(mfeStructP),
        justStruct(justStructP),
        stochBTStruct(stochBTStructP),
        PStruct(PStructP),
        centStruct(centStructP),
        MEAStruct(MEAStructP),
        freeEnergy(freeEnergyP),
        ensembleFreq(ensembleFreqP),
        alignment(alignmentP),
        OTHER(".*");

        String regex;

        private AlifoldLine(String string2) {
            this.regex = string2;
        }
    }
}

