/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.sequence;

import compbio.data.sequence.Range;
import compbio.data.sequence.Score;
import compbio.data.sequence.ScoreManager;
import compbio.util.SysPrefs;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class RNAStructScoreManager
extends ScoreManager {
    private RNAStructScoreManager() {
    }

    public RNAStructScoreManager(List<String> list, List<TreeSet<Score>> list2) {
        assert (list.size() == list2.size());
        ArrayList<ScoreManager.ScoreHolder> arrayList = new ArrayList<ScoreManager.ScoreHolder>();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(new ScoreManager.ScoreHolder(list.get(i), (Set<Score>)list2.get(i)));
        }
        this.seqScores = arrayList;
    }

    public static RNAStructScoreManager newInstance(List<String> list, List<TreeSet<Score>> list2) {
        return new RNAStructScoreManager(list, list2);
    }

    public List<String> getStructs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ScoreManager.ScoreHolder scoreHolder : this.seqScores) {
            arrayList.add(scoreHolder.id);
        }
        return arrayList;
    }

    public List<TreeSet<Score>> getData() {
        ArrayList<TreeSet<Score>> arrayList = new ArrayList<TreeSet<Score>>();
        for (ScoreManager.ScoreHolder scoreHolder : this.seqScores) {
            arrayList.add(scoreHolder.scores);
        }
        return arrayList;
    }

    public String toString() {
        String string = "";
        string = string + this.getStructs().get(0) + SysPrefs.newlinechar;
        for (int i = 1; i < this.getStructs().size(); ++i) {
            string = string + this.getStructs().get(i).toString();
            if (this.getData().get(i).first().getScores().size() > 0) {
                ArrayList<Float> arrayList = this.getData().get(i).first().getScores();
                if (arrayList.size() >= 3) {
                    string = string + " (" + ((Float)arrayList.get(0)).toString() + " = " + ((Float)arrayList.get(1)).toString() + " + " + ((Float)arrayList.get(2)).toString() + ")" + SysPrefs.newlinechar;
                    continue;
                }
                if (this.getData().get(i).first().getMethod().equals("alifoldMEA")) {
                    string = string + " { " + ((Float)arrayList.get(0)).toString() + " MEA=" + ((Float)arrayList.get(1)).toString() + "}" + SysPrefs.newlinechar;
                    continue;
                }
                if (arrayList.size() < 2) continue;
                string = string + " [" + ((Float)arrayList.get(0)).toString() + ", " + ((Float)arrayList.get(1)).toString() + "]" + SysPrefs.newlinechar;
                continue;
            }
            string = string + SysPrefs.newlinechar;
        }
        if (this.getData().get(0).first().getScores().size() > 0) {
            Iterator<Score> iterator = this.getData().get(0).iterator();
            string = string + "Base Pairings followed by probability" + SysPrefs.newlinechar;
            for (int i = 0; i < this.getData().get(0).size(); ++i) {
                Score score = iterator.next();
                Range range = score.getRanges().first();
                Float f = score.getScores().get(0);
                string = string + String.format("%4d  %4d    %.1f%n", range.from, range.to, f);
            }
        }
        return string;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof RNAStructScoreManager)) {
            return false;
        }
        RNAStructScoreManager rNAStructScoreManager = (RNAStructScoreManager)object;
        if (this.getStructs() == null ? rNAStructScoreManager.getStructs() != null : !((Object)this.getStructs()).equals(rNAStructScoreManager.getStructs())) {
            return false;
        }
        return !(this.getData() == null ? rNAStructScoreManager.getData() != null : !((Object)this.getData()).equals(rNAStructScoreManager.getData()));
    }
}

