/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.sequence;

import compbio.data.sequence.RNAStructScoreManager;
import compbio.data.sequence.Score;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;

@XmlSeeAlso(value={RNAStructScoreManager.class})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ScoreManager {
    @XmlTransient
    public static final String SINGLE_ENTRY_KEY = "Alignment";
    protected List<ScoreHolder> seqScores;

    protected ScoreManager() {
    }

    private ScoreManager(String string, Set<Score> set) {
        this.seqScores = new ArrayList<ScoreHolder>();
        this.seqScores.add(new ScoreHolder(string, set));
    }

    private ScoreManager(Map<String, Set<Score>> map) {
        ArrayList<ScoreHolder> arrayList = new ArrayList<ScoreHolder>();
        for (Map.Entry<String, Set<Score>> entry : map.entrySet()) {
            arrayList.add(new ScoreHolder(entry.getKey(), entry.getValue()));
        }
        this.seqScores = arrayList;
    }

    public static ScoreManager newInstance(Map<String, Set<Score>> map) {
        return new ScoreManager(map);
    }

    public static ScoreManager newInstanceSingleScore(Map<String, Score> map) {
        TreeMap<String, Set<Score>> treeMap = new TreeMap<String, Set<Score>>();
        for (Map.Entry<String, Score> entry : map.entrySet()) {
            TreeSet<Score> treeSet = new TreeSet<Score>();
            treeSet.add(entry.getValue());
            treeMap.put(entry.getKey(), treeSet);
        }
        return new ScoreManager(treeMap);
    }

    public static ScoreManager newInstanceSingleSequence(Set<Score> set) {
        return new ScoreManager(SINGLE_ENTRY_KEY, new TreeSet<Score>(set));
    }

    public Map<String, TreeSet<Score>> asMap() {
        TreeMap<String, TreeSet<Score>> treeMap = new TreeMap<String, TreeSet<Score>>();
        for (ScoreHolder scoreHolder : this.seqScores) {
            TreeSet<Score> treeSet = treeMap.put(scoreHolder.id, new TreeSet<Score>((SortedSet<Score>)scoreHolder.scores));
            if (treeSet == null) continue;
            throw new IllegalStateException("Cannot represent this ScoreManager instance as a Map as it contains duplicated keys: " + scoreHolder.id);
        }
        return treeMap;
    }

    public Set<Score> asSet() {
        if (this.seqScores.size() == 0 || this.seqScores.size() > 1) {
            throw new IllegalStateException("This ScoreManager has no or multiple sequence entries and thus cannot be represented as a Set. Number of entries are: " + this.seqScores.size());
        }
        ScoreHolder scoreHolder = this.seqScores.get(0);
        return scoreHolder.scores;
    }

    public int getNumberOfSeq() {
        return this.seqScores.size();
    }

    public ScoreHolder getAnnotationForSequence(String string) {
        for (ScoreHolder scoreHolder : this.seqScores) {
            if (!scoreHolder.id.equals(string)) continue;
            return scoreHolder;
        }
        return null;
    }

    public void writeOut(Writer writer) throws IOException {
        assert (writer != null) : "Output steam is not defined!";
        if (this.seqScores == null) {
            return;
        }
        for (ScoreHolder scoreHolder : this.seqScores) {
            if (scoreHolder == null) continue;
            scoreHolder.writeOut(writer);
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.seqScores == null ? 0 : ((Object)this.seqScores).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ScoreManager scoreManager = (ScoreManager)object;
        return !(this.seqScores == null ? scoreManager.seqScores != null : !((Object)this.seqScores).equals(scoreManager.seqScores));
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class ScoreHolder {
        public String id;
        public TreeSet<Score> scores;

        private ScoreHolder() {
        }

        ScoreHolder(String string, Set<Score> set) {
            this.id = string;
            this.scores = new TreeSet<Score>(set);
        }

        public void writeOut(Writer writer) throws IOException {
            writer.write(">" + this.id + "\n");
            Score.write(this.scores, writer);
        }

        public Score getScoreByMethod(Enum<?> enum_) {
            for (Score score : this.scores) {
                if (!enum_.toString().equals(score.getMethod())) continue;
                return score;
            }
            return null;
        }

        public Score getScoreByMethod(String string) {
            for (Score score : this.scores) {
                if (!string.toString().equals(score.getMethod())) continue;
                return score;
            }
            return null;
        }

        public int getNumberOfScores() {
            return this.scores.size();
        }

        public int hashCode() {
            int n = 1;
            n = 17 * n + (this.id == null ? 0 : this.id.hashCode());
            n = 17 * n + (this.scores == null ? 0 : this.scores.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ScoreHolder scoreHolder = (ScoreHolder)object;
            if (this.id == null ? scoreHolder.id != null : !this.id.equals(scoreHolder.id)) {
                return false;
            }
            return !(this.scores == null ? scoreHolder.scores != null : !this.scores.equals(scoreHolder.scores));
        }
    }
}

