/*
 * Decompiled with CFR 0.152.
 */
package compbio.metadata;

import compbio.metadata.Argument;
import compbio.metadata.Option;
import compbio.metadata.Preset;
import compbio.metadata.RunnerConfig;
import compbio.util.Util;
import java.util.List;
import javax.xml.bind.ValidationException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="presets")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PresetManager<T> {
    @XmlElement(required=true)
    String runnerClassName;
    @XmlElement(required=true)
    List<Preset<T>> preset;
    public static final String LOCAL_ENGINE_LIMIT_PRESET = "# LocalEngineExecutionLimit #";

    public List<Preset<T>> getPresets() {
        return this.preset;
    }

    public void setPresets(List<Preset<T>> list) {
        this.preset = list;
    }

    public String getRunnerClassName() {
        return this.runnerClassName;
    }

    public void setRunnerClassName(String string) {
        this.runnerClassName = string;
    }

    public Preset<T> getPresetByName(String string) {
        for (Preset<T> preset : this.preset) {
            if (!preset.getName().equalsIgnoreCase(string)) continue;
            return preset;
        }
        return null;
    }

    boolean isComposite(String string) {
        assert (string != null);
        return string.contains(" ");
    }

    boolean containsValue(List<String> list, String string) {
        assert (!Util.isEmpty(string));
        for (String string2 : list) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    boolean isNumeric(String string) {
        assert (string != null);
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public void validate(RunnerConfig<T> runnerConfig) throws ValidationException {
        for (Preset<T> preset : this.preset) {
            if (Util.isEmpty(preset.name)) {
                throw new ValidationException("Preset name must not be empty!");
            }
            List<String> list = preset.getOptions();
            if (list == null || list.size() == 0) {
                throw new ValidationException("At lease one option must be defined for a preset!");
            }
            for (String string : list) {
                if (this.isComposite(string)) {
                    String string2 = string.split(" ")[0];
                    Argument<T> argument = this.getArgument(runnerConfig, string2);
                    String string3 = string.split(" ")[1];
                    if (this.isNumeric(string3) || this.containsValue(argument.getPossibleValues(), string3)) continue;
                    throw new ValidationException("Value " + string3 + " is not found in the option " + string2);
                }
                this.getArgument(runnerConfig, string);
            }
        }
    }

    Argument<T> getArgument(RunnerConfig<T> runnerConfig, String string) throws ValidationException {
        Option<T> option = runnerConfig.getArgumentByOptionName(string);
        if (option == null) {
            throw new ValidationException("Option " + string + " is not found in the option list (<RunnerName>Parameter.xml file)");
        }
        return option;
    }

    public String toString() {
        String string = "Runner: " + this.runnerClassName + "\n";
        for (Preset<T> preset : this.preset) {
            string = string + "##############################################################################\n" + preset.toString() + "\n";
        }
        return string;
    }
}

