/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.client;

import compbio.data.sequence.Alignment;
import compbio.data.sequence.ClustalAlignmentUtil;
import compbio.data.sequence.ScoreManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class IOHelper {
    static File getFile(String[] stringArray, String string, boolean bl) throws IOException {
        assert (string != null && string.trim().length() != 0);
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string2;
            String string3 = string2 = stringArray2[i];
            if (!(string3 = string3.trim()).toLowerCase().startsWith(string + "=")) continue;
            string3 = string3.substring((string + "=").length());
            File file = new File(string3);
            if (bl && !file.exists()) {
                System.out.println(string + " file " + file.getAbsolutePath() + " does not exist");
                return null;
            }
            if (!bl && !file.exists()) {
                file.createNewFile();
            }
            if (!file.canRead()) {
                System.out.println("Cannot read " + string + " file " + file.getAbsolutePath());
                return null;
            }
            return file;
        }
        return null;
    }

    static List<String> loadParameters(File file) throws IOException {
        assert (file != null && file.exists());
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).length() == 0) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    static Writer getWriter(File file) throws IOException {
        assert (file != null && file.exists());
        return new FileWriter(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeOut(Writer writer, Alignment alignment) {
        try {
            ClustalAlignmentUtil.writeClustalAlignment(writer, alignment);
        }
        catch (IOException iOException) {
            System.err.println("Problems writing output file! Stack trace is below: ");
            iOException.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeOut(Writer writer, ScoreManager scoreManager) {
        if (scoreManager == null) {
            return;
        }
        try {
            scoreManager.writeOut(writer);
        }
        catch (IOException iOException) {
            System.err.println("Problems writing output file! Stack trace is below: ");
            iOException.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

