/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.client;

import compbio.data.msa.JABAService;
import compbio.data.msa.Metadata;
import compbio.data.msa.MsaWS;
import compbio.data.msa.RegistryWS;
import compbio.data.msa.SequenceAnnotation;
import compbio.data.sequence.Alignment;
import compbio.data.sequence.AlignmentMetadata;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.ScoreManager;
import compbio.data.sequence.SequenceUtil;
import compbio.data.sequence.UnknownFileFormatException;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.Limit;
import compbio.metadata.Option;
import compbio.metadata.Preset;
import compbio.metadata.ResultNotAvailableException;
import compbio.metadata.WrongParameterException;
import compbio.util.FileUtil;
import compbio.ws.client.CmdHelper;
import compbio.ws.client.IOHelper;
import compbio.ws.client.MetadataHelper;
import compbio.ws.client.Services;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;

public class Jws2Client {
    private static final Logger log = Logger.getLogger(Jws2Client.class.getCanonicalName());

    public static boolean validURL(String string) {
        try {
            if (string == null || string.trim().length() == 0) {
                return false;
            }
            new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        return true;
    }

    <T> Jws2Client(String[] stringArray) throws IOException {
        Object object;
        Iterator iterator;
        Object object2;
        Object object3;
        Services services;
        String string;
        boolean bl;
        String string2 = CmdHelper.getHost(stringArray);
        if (string2 == null) {
            System.err.println("Host name is not provided!");
            System.out.println("\r\nUsage: java -jar <JAR file name> -h=host_and_context <-s=serviceName> ACTION [OPTIONS] \r\n\r\n       -h=<host_context> - a full URL to the JABAWS web server including context path e.g. http://10.31.1.159:8080/ws\r\n       -s=<ServiceName>  - a name of servise (the full list can be obtain with the option -list)\r\n                           <serviceName> is required for all ACTIONS except -list\r\n\r\nACTIONS: \r\n        -i=<inputFile>  - defines an input file. For most services this is a FASTA file with initial sequences\r\n        -list           - lists all available web services\r\n        -test           - tests functioning of <ServiceName> \r\n        -parameters     - lists parameters supported by <ServiceName>\r\n        -presets        - lists presets supported by <ServiceName>\r\n        -limits         - lists limits of <ServiceName>\r\n\r\nN.B. If an input file is specified with -i other actions are ignored!\r\n\r\nOPTIONS (used with the -i action only):\r\n        -r=<presetName>  - name of the preset to use\r\n        -o=<outputFile>  - file with output results\r\n        -f=<paramFile>   - file with the list of parameters to use.\r\n\r\nPlease note that -r and -f options cannot be used together. \r\nAlignment/Prediction is done with either preset or a parameters from the file, but not both!\r\n\r\nEXAMPLES: \r\n<THECLIENT> is java -jar <JAR file name>\r\n\r\n1) List all available services on the host:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -list\r\n\r\n2) Test Clustal web service:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=ClustalWS -test \r\n\r\n3) Align sequence from file input.txt with Probcons. Record resulting alignment \r\n   into the output.txt:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=ProbconsWS -i=input.txt -o=output.txt\r\n\r\n4) Calculate disorder with Disembl take input from input.txt with output results\r\n    to be printed out to the standard output:\r\n    <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=DisemblWS -i=input.txt \r\n\r\n5) List all parameters available for AAconWS service:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=AAconWS -parameters\r\n\r\n6) Calculate conservation with AAConWS using LANDGRAF method, for Clustal alignment \r\n   from input.txt and report the scores to the standard output:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=AAconWS -i=input.txt -f=prm.txt \r\n\r\n   Where the content of prm.txt file is -m=LANDGRAF\r\nN.B. The list of the supported parameters can be obtained as shown in the example 5.\r\n");
            System.exit(1);
        }
        if (!Jws2Client.validURL(string2)) {
            System.err.println("Host name is not valid!");
            System.out.println("\r\nUsage: java -jar <JAR file name> -h=host_and_context <-s=serviceName> ACTION [OPTIONS] \r\n\r\n       -h=<host_context> - a full URL to the JABAWS web server including context path e.g. http://10.31.1.159:8080/ws\r\n       -s=<ServiceName>  - a name of servise (the full list can be obtain with the option -list)\r\n                           <serviceName> is required for all ACTIONS except -list\r\n\r\nACTIONS: \r\n        -i=<inputFile>  - defines an input file. For most services this is a FASTA file with initial sequences\r\n        -list           - lists all available web services\r\n        -test           - tests functioning of <ServiceName> \r\n        -parameters     - lists parameters supported by <ServiceName>\r\n        -presets        - lists presets supported by <ServiceName>\r\n        -limits         - lists limits of <ServiceName>\r\n\r\nN.B. If an input file is specified with -i other actions are ignored!\r\n\r\nOPTIONS (used with the -i action only):\r\n        -r=<presetName>  - name of the preset to use\r\n        -o=<outputFile>  - file with output results\r\n        -f=<paramFile>   - file with the list of parameters to use.\r\n\r\nPlease note that -r and -f options cannot be used together. \r\nAlignment/Prediction is done with either preset or a parameters from the file, but not both!\r\n\r\nEXAMPLES: \r\n<THECLIENT> is java -jar <JAR file name>\r\n\r\n1) List all available services on the host:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -list\r\n\r\n2) Test Clustal web service:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=ClustalWS -test \r\n\r\n3) Align sequence from file input.txt with Probcons. Record resulting alignment \r\n   into the output.txt:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=ProbconsWS -i=input.txt -o=output.txt\r\n\r\n4) Calculate disorder with Disembl take input from input.txt with output results\r\n    to be printed out to the standard output:\r\n    <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=DisemblWS -i=input.txt \r\n\r\n5) List all parameters available for AAconWS service:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=AAconWS -parameters\r\n\r\n6) Calculate conservation with AAConWS using LANDGRAF method, for Clustal alignment \r\n   from input.txt and report the scores to the standard output:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=AAconWS -i=input.txt -f=prm.txt \r\n\r\n   Where the content of prm.txt file is -m=LANDGRAF\r\nN.B. The list of the supported parameters can be obtained as shown in the example 5.\r\n");
            System.exit(1);
        }
        if (bl = CmdHelper.listServices(stringArray)) {
            Jws2Client.listAllServices(string2);
            System.exit(0);
        }
        if ((string = CmdHelper.getServiceName(stringArray)) == null) {
            System.err.println("Service name is no provided!");
            System.out.println("\r\nUsage: java -jar <JAR file name> -h=host_and_context <-s=serviceName> ACTION [OPTIONS] \r\n\r\n       -h=<host_context> - a full URL to the JABAWS web server including context path e.g. http://10.31.1.159:8080/ws\r\n       -s=<ServiceName>  - a name of servise (the full list can be obtain with the option -list)\r\n                           <serviceName> is required for all ACTIONS except -list\r\n\r\nACTIONS: \r\n        -i=<inputFile>  - defines an input file. For most services this is a FASTA file with initial sequences\r\n        -list           - lists all available web services\r\n        -test           - tests functioning of <ServiceName> \r\n        -parameters     - lists parameters supported by <ServiceName>\r\n        -presets        - lists presets supported by <ServiceName>\r\n        -limits         - lists limits of <ServiceName>\r\n\r\nN.B. If an input file is specified with -i other actions are ignored!\r\n\r\nOPTIONS (used with the -i action only):\r\n        -r=<presetName>  - name of the preset to use\r\n        -o=<outputFile>  - file with output results\r\n        -f=<paramFile>   - file with the list of parameters to use.\r\n\r\nPlease note that -r and -f options cannot be used together. \r\nAlignment/Prediction is done with either preset or a parameters from the file, but not both!\r\n\r\nEXAMPLES: \r\n<THECLIENT> is java -jar <JAR file name>\r\n\r\n1) List all available services on the host:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -list\r\n\r\n2) Test Clustal web service:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=ClustalWS -test \r\n\r\n3) Align sequence from file input.txt with Probcons. Record resulting alignment \r\n   into the output.txt:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=ProbconsWS -i=input.txt -o=output.txt\r\n\r\n4) Calculate disorder with Disembl take input from input.txt with output results\r\n    to be printed out to the standard output:\r\n    <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=DisemblWS -i=input.txt \r\n\r\n5) List all parameters available for AAconWS service:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=AAconWS -parameters\r\n\r\n6) Calculate conservation with AAConWS using LANDGRAF method, for Clustal alignment \r\n   from input.txt and report the scores to the standard output:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=AAconWS -i=input.txt -f=prm.txt \r\n\r\n   Where the content of prm.txt file is -m=LANDGRAF\r\nN.B. The list of the supported parameters can be obtained as shown in the example 5.\r\n");
            System.exit(1);
        }
        if ((services = Services.getService(string)) == null) {
            object3 = "Service " + string + " is no available! Valid values are: ";
            System.err.println((String)object3 + Arrays.toString((Object[])Services.values()));
            System.out.println("\r\nUsage: java -jar <JAR file name> -h=host_and_context <-s=serviceName> ACTION [OPTIONS] \r\n\r\n       -h=<host_context> - a full URL to the JABAWS web server including context path e.g. http://10.31.1.159:8080/ws\r\n       -s=<ServiceName>  - a name of servise (the full list can be obtain with the option -list)\r\n                           <serviceName> is required for all ACTIONS except -list\r\n\r\nACTIONS: \r\n        -i=<inputFile>  - defines an input file. For most services this is a FASTA file with initial sequences\r\n        -list           - lists all available web services\r\n        -test           - tests functioning of <ServiceName> \r\n        -parameters     - lists parameters supported by <ServiceName>\r\n        -presets        - lists presets supported by <ServiceName>\r\n        -limits         - lists limits of <ServiceName>\r\n\r\nN.B. If an input file is specified with -i other actions are ignored!\r\n\r\nOPTIONS (used with the -i action only):\r\n        -r=<presetName>  - name of the preset to use\r\n        -o=<outputFile>  - file with output results\r\n        -f=<paramFile>   - file with the list of parameters to use.\r\n\r\nPlease note that -r and -f options cannot be used together. \r\nAlignment/Prediction is done with either preset or a parameters from the file, but not both!\r\n\r\nEXAMPLES: \r\n<THECLIENT> is java -jar <JAR file name>\r\n\r\n1) List all available services on the host:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -list\r\n\r\n2) Test Clustal web service:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=ClustalWS -test \r\n\r\n3) Align sequence from file input.txt with Probcons. Record resulting alignment \r\n   into the output.txt:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=ProbconsWS -i=input.txt -o=output.txt\r\n\r\n4) Calculate disorder with Disembl take input from input.txt with output results\r\n    to be printed out to the standard output:\r\n    <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=DisemblWS -i=input.txt \r\n\r\n5) List all parameters available for AAconWS service:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=AAconWS -parameters\r\n\r\n6) Calculate conservation with AAConWS using LANDGRAF method, for Clustal alignment \r\n   from input.txt and report the scores to the standard output:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=AAconWS -i=input.txt -f=prm.txt \r\n\r\n   Where the content of prm.txt file is -m=LANDGRAF\r\nN.B. The list of the supported parameters can be obtained as shown in the example 5.\r\n");
            System.exit(1);
        }
        if (CmdHelper.testService(stringArray)) {
            Jws2Client.testService(string2, services, new PrintWriter(System.out, true));
            System.exit(0);
        }
        object3 = (Metadata)((Object)Jws2Client.connect(string2, services));
        Preset preset = null;
        if (null != CmdHelper.getPresetName(stringArray)) {
            preset = MetadataHelper.getPreset(object3, CmdHelper.getPresetName(stringArray));
        }
        List list = null;
        if (null != IOHelper.getFile(stringArray, "-f", true)) {
            object2 = IOHelper.loadParameters(IOHelper.getFile(stringArray, "-f", true));
            list = MetadataHelper.processParameters(object2, object3.getRunnerOptions());
        }
        if (null != IOHelper.getFile(stringArray, "-i", true)) {
            Object object4;
            object2 = IOHelper.getFile(stringArray, "-i", true);
            iterator = IOHelper.getFile(stringArray, "-o", false);
            object = null;
            object = iterator != null ? IOHelper.getWriter(iterator) : new PrintWriter(System.out, true);
            if (services.getServiceType() == SequenceAnnotation.class) {
                object4 = Jws2Client.analize(object2, (SequenceAnnotation)object3, preset, list);
                IOHelper.writeOut(object, (ScoreManager)object4);
                ((Writer)object).close();
            } else if (services.getServiceType() == MsaWS.class) {
                object4 = Jws2Client.align(object2, (MsaWS)object3, preset, list);
                IOHelper.writeOut(object, (Alignment)object4);
                ((Writer)object).close();
                AlignmentMetadata alignmentMetadata = ((Alignment)object4).getMetadata();
                System.out.println("Output has been prepared with " + (Object)((Object)alignmentMetadata.getProgram()));
            }
        }
        if (CmdHelper.listParameters(stringArray)) {
            object2 = MetadataHelper.getParametersList(object3, string2);
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (Option)iterator.next();
                System.out.println("##############################################################################\n" + ((Option)object).toString());
            }
        }
        if (CmdHelper.listPresets(stringArray)) {
            object2 = MetadataHelper.getPresetList(object3);
            if (null != object2) {
                System.out.print(object2);
            } else {
                System.out.println("No presets are defined for the Web service");
            }
        }
        if (CmdHelper.listLimits(stringArray)) {
            object2 = MetadataHelper.getLimits(object3);
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                System.out.println("##############################################################################\n" + ((Limit)object).toString());
            }
        }
        log.fine("Disconnecting...");
        ((Closeable)object3).close();
        log.fine("Disconnected successfully!");
    }

    public static JABAService connect(String string, Services services) throws WebServiceException, ConnectException {
        URL uRL = null;
        log.log(Level.FINE, "Attempting to connect with " + services.toString() + "...");
        System.out.println("Attempting to connect with " + services.toString() + "...");
        try {
            uRL = new URL(string + "/" + services.toString() + "?wsdl");
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        Service service = null;
        try {
            service = services.getService(uRL, services.getServiceNamespace());
        }
        catch (WebServiceException webServiceException) {
            webServiceException.printStackTrace();
        }
        if (service == null) {
            throw new ConnectException("Could not connect to " + uRL + ". Is the server down?");
        }
        JABAService jABAService = services.getInterface(service);
        log.log(Level.INFO, "Connected successfully!");
        return jABAService;
    }

    public static RegistryWS connectToRegistry(String string) throws WebServiceException, ConnectException {
        URL uRL = null;
        String string2 = "RegistryWS";
        log.log(Level.FINE, "Attempting to connect...");
        try {
            uRL = new URL(string + "/" + string2 + "?wsdl");
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        QName qName = new QName("http://msa.data.compbio/01/12/2010/", string2);
        Service service = Service.create(uRL, (QName)qName);
        if (service == null) {
            throw new ConnectException("Could not connect to " + uRL + ". Is the server down?");
        }
        QName qName2 = new QName(service.getServiceName().getNamespaceURI(), string2 + "Port");
        RegistryWS registryWS = (RegistryWS)service.getPort(qName2, RegistryWS.class);
        log.log(Level.INFO, "Connected to " + string2 + " successfully!");
        return registryWS;
    }

    public static void testService(String string, Services services, PrintWriter printWriter) throws ConnectException, WebServiceException {
        RegistryWS registryWS = Jws2Client.connectToRegistry(string);
        if (registryWS != null) {
            String string2 = registryWS.testService(services);
            printWriter.println("Service " + (Object)((Object)services) + " testing results: ");
            printWriter.println(string2);
            FileUtil.closeSilently((Closeable)((Object)registryWS));
        }
        printWriter.flush();
    }

    private static void listAllServices(String string) throws WebServiceException, IOException {
        RegistryWS registryWS = Jws2Client.connectToRegistry(string);
        Set<Object> set = Collections.emptySet();
        if (registryWS == null) {
            System.out.println("Failed to connect to the registry! ");
            return;
        }
        set = registryWS.getSupportedServices();
        FileUtil.closeSilently((Closeable)((Object)registryWS));
        if (!set.isEmpty()) {
            System.out.println("There are " + set.size() + " services at " + string + ":");
            String string2 = "\n\rThe list:\n";
            System.out.println(string2 + Services.toString(set));
        }
    }

    static <T> ScoreManager analize(List<FastaSequence> list, SequenceAnnotation<T> sequenceAnnotation, Preset<T> preset, List<Option<T>> list2) {
        ScoreManager scoreManager = null;
        try {
            String string = null;
            if (list2 != null && preset != null) {
                System.out.println("WARN: Parameters (-f) are defined together with a preset (-r) ignoring preset!");
            }
            string = list2 != null ? sequenceAnnotation.customAnalize(list, list2) : (preset != null ? sequenceAnnotation.presetAnalize(list, preset) : sequenceAnnotation.analize(list));
            System.out.println("\n\rcalling predictor.........");
            Thread.sleep(1000L);
            scoreManager = sequenceAnnotation.getAnnotation(string);
        }
        catch (JobSubmissionException jobSubmissionException) {
            System.err.println("Exception while submitting job to a web server. Exception details are below:");
            jobSubmissionException.printStackTrace();
        }
        catch (ResultNotAvailableException resultNotAvailableException) {
            System.err.println("Exception while waiting for results. Exception details are below:");
            resultNotAvailableException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            System.err.println("Exception while waiting for results. Exception details are below:");
            interruptedException.printStackTrace();
        }
        catch (WrongParameterException wrongParameterException) {
            String string = "Parsing the web method input parameters failed Exception details are below:";
            System.err.println(string);
            wrongParameterException.printStackTrace();
        }
        return scoreManager;
    }

    static <T> ScoreManager analize(File file, SequenceAnnotation<T> sequenceAnnotation, Preset<T> preset, List<Option<T>> list) {
        List<FastaSequence> list2 = null;
        try {
            list2 = SequenceUtil.openInputStream(file.getAbsolutePath());
            assert (!list2.isEmpty()) : "Input is empty!";
        }
        catch (IOException iOException) {
            String string = "Reading the input file failed. Check that the file contains a list of FASTA records!\n";
            System.err.println(string + "Exception details are below:");
            iOException.printStackTrace();
        }
        catch (UnknownFileFormatException unknownFileFormatException) {
            String string = "Reading the input file failed. Exception details are below:";
            System.err.println(string);
            System.out.println(unknownFileFormatException.getMessage());
            unknownFileFormatException.printStackTrace();
        }
        return Jws2Client.analize(list2, sequenceAnnotation, preset, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> Alignment align(File file, MsaWS<T> msaWS, Preset<T> preset, List<Option<T>> list) {
        FileInputStream fileInputStream = null;
        Alignment alignment = null;
        try {
            fileInputStream = new FileInputStream(file);
            List<FastaSequence> list2 = SequenceUtil.readFasta(fileInputStream);
            fileInputStream.close();
            String string = null;
            if (list != null && preset != null) {
                System.out.println("WARN: Parameters (-f) are defined together with a preset (-r) ignoring preset!");
            }
            string = list != null ? msaWS.customAlign(list2, list) : (preset != null ? msaWS.presetAlign(list2, preset) : msaWS.align(list2));
            System.out.println("\ncalling program.........");
            Thread.sleep(1000L);
            alignment = msaWS.getResult(string);
        }
        catch (IOException iOException) {
            System.err.println("Exception while reading the input file. Check that the input file is a FASTA file! Exception details are below:");
            iOException.printStackTrace();
        }
        catch (JobSubmissionException jobSubmissionException) {
            System.err.println("Exception while submitting job to a web server. Exception details are below:");
            jobSubmissionException.printStackTrace();
        }
        catch (ResultNotAvailableException resultNotAvailableException) {
            System.err.println("Exception while waiting for results. Exception details are below:");
            resultNotAvailableException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (WrongParameterException wrongParameterException) {
            wrongParameterException.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return alignment;
    }

    public static void main(String[] stringArray) {
        if (stringArray == null) {
            System.out.println("\r\nUsage: java -jar <JAR file name> -h=host_and_context <-s=serviceName> ACTION [OPTIONS] \r\n\r\n       -h=<host_context> - a full URL to the JABAWS web server including context path e.g. http://10.31.1.159:8080/ws\r\n       -s=<ServiceName>  - a name of servise (the full list can be obtain with the option -list)\r\n                           <serviceName> is required for all ACTIONS except -list\r\n\r\nACTIONS: \r\n        -i=<inputFile>  - defines an input file. For most services this is a FASTA file with initial sequences\r\n        -list           - lists all available web services\r\n        -test           - tests functioning of <ServiceName> \r\n        -parameters     - lists parameters supported by <ServiceName>\r\n        -presets        - lists presets supported by <ServiceName>\r\n        -limits         - lists limits of <ServiceName>\r\n\r\nN.B. If an input file is specified with -i other actions are ignored!\r\n\r\nOPTIONS (used with the -i action only):\r\n        -r=<presetName>  - name of the preset to use\r\n        -o=<outputFile>  - file with output results\r\n        -f=<paramFile>   - file with the list of parameters to use.\r\n\r\nPlease note that -r and -f options cannot be used together. \r\nAlignment/Prediction is done with either preset or a parameters from the file, but not both!\r\n\r\nEXAMPLES: \r\n<THECLIENT> is java -jar <JAR file name>\r\n\r\n1) List all available services on the host:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -list\r\n\r\n2) Test Clustal web service:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=ClustalWS -test \r\n\r\n3) Align sequence from file input.txt with Probcons. Record resulting alignment \r\n   into the output.txt:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=ProbconsWS -i=input.txt -o=output.txt\r\n\r\n4) Calculate disorder with Disembl take input from input.txt with output results\r\n    to be printed out to the standard output:\r\n    <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=DisemblWS -i=input.txt \r\n\r\n5) List all parameters available for AAconWS service:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=AAconWS -parameters\r\n\r\n6) Calculate conservation with AAConWS using LANDGRAF method, for Clustal alignment \r\n   from input.txt and report the scores to the standard output:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=AAconWS -i=input.txt -f=prm.txt \r\n\r\n   Where the content of prm.txt file is -m=LANDGRAF\r\nN.B. The list of the supported parameters can be obtained as shown in the example 5.\r\n");
            System.exit(1);
        }
        if (stringArray.length < 2) {
            System.err.println("Host (-h=<host>, e.g. -h=http://www.compbio.dundee.ac.uk/jabaws) and service (-s=<ServiceName>, e.g. -s=MafftWS) are required!");
            System.out.println("\r\nUsage: java -jar <JAR file name> -h=host_and_context <-s=serviceName> ACTION [OPTIONS] \r\n\r\n       -h=<host_context> - a full URL to the JABAWS web server including context path e.g. http://10.31.1.159:8080/ws\r\n       -s=<ServiceName>  - a name of servise (the full list can be obtain with the option -list)\r\n                           <serviceName> is required for all ACTIONS except -list\r\n\r\nACTIONS: \r\n        -i=<inputFile>  - defines an input file. For most services this is a FASTA file with initial sequences\r\n        -list           - lists all available web services\r\n        -test           - tests functioning of <ServiceName> \r\n        -parameters     - lists parameters supported by <ServiceName>\r\n        -presets        - lists presets supported by <ServiceName>\r\n        -limits         - lists limits of <ServiceName>\r\n\r\nN.B. If an input file is specified with -i other actions are ignored!\r\n\r\nOPTIONS (used with the -i action only):\r\n        -r=<presetName>  - name of the preset to use\r\n        -o=<outputFile>  - file with output results\r\n        -f=<paramFile>   - file with the list of parameters to use.\r\n\r\nPlease note that -r and -f options cannot be used together. \r\nAlignment/Prediction is done with either preset or a parameters from the file, but not both!\r\n\r\nEXAMPLES: \r\n<THECLIENT> is java -jar <JAR file name>\r\n\r\n1) List all available services on the host:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -list\r\n\r\n2) Test Clustal web service:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=ClustalWS -test \r\n\r\n3) Align sequence from file input.txt with Probcons. Record resulting alignment \r\n   into the output.txt:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=ProbconsWS -i=input.txt -o=output.txt\r\n\r\n4) Calculate disorder with Disembl take input from input.txt with output results\r\n    to be printed out to the standard output:\r\n    <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=DisemblWS -i=input.txt \r\n\r\n5) List all parameters available for AAconWS service:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=AAconWS -parameters\r\n\r\n6) Calculate conservation with AAConWS using LANDGRAF method, for Clustal alignment \r\n   from input.txt and report the scores to the standard output:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=AAconWS -i=input.txt -f=prm.txt \r\n\r\n   Where the content of prm.txt file is -m=LANDGRAF\r\nN.B. The list of the supported parameters can be obtained as shown in the example 5.\r\n");
            System.exit(1);
        }
        try {
            new Jws2Client(stringArray);
        }
        catch (IOException iOException) {
            log.log(Level.SEVERE, "IOException in client! " + iOException.getMessage(), iOException.getCause());
            System.err.println("Cannot write output file! Stack trace: ");
            iOException.printStackTrace();
        }
    }
}

